/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core.model.presentation.valueresolvers.property;

import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.java.IJavaType;
import com.intellij.tapestry.core.model.presentation.valueresolvers.AbstractValueResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.ValueResolverContext;
import com.intellij.tapestry.core.model.presentation.valueresolvers.property.SingleMethodResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.property.SinglePropertyResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.property.specialcases.SpecialCaseBooleanResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.property.specialcases.SpecialCaseLiteralStringResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.property.specialcases.SpecialCaseNullResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.property.specialcases.SpecialCaseNumericResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.property.specialcases.SpecialCaseRangeIntegersResolver;
import com.intellij.tapestry.core.model.presentation.valueresolvers.property.specialcases.SpecialCaseThisResolver;
import java.util.StringTokenizer;
import org.apache.commons.chain.Chain;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.impl.ChainBase;

public class PropResolver
extends AbstractValueResolver {
    private static final String PREFIX = "prop";
    private static final Chain _specialCasesChain = new ChainBase(new Command[]{new SpecialCaseBooleanResolver(), new SpecialCaseNullResolver(), new SpecialCaseThisResolver(), new SpecialCaseLiteralStringResolver(), new SpecialCaseNumericResolver(), new SpecialCaseRangeIntegersResolver()});
    private static final Chain _normalCasesChain = new ChainBase(new Command[]{new SingleMethodResolver(), new SinglePropertyResolver()});

    public boolean execute(Context context) throws Exception {
        String prefix = PropResolver.getPrefix(((ValueResolverContext)context).getValue(), ((ValueResolverContext)context).getDefaultPrefix());
        if (prefix == null || !prefix.equals(PREFIX)) {
            return false;
        }
        if (_specialCasesChain.execute(context)) {
            return true;
        }
        StringTokenizer tokenizer = new StringTokenizer(PropResolver.getCleanValue(((ValueResolverContext)context).getValue()), ".");
        IJavaType currentType = ((ValueResolverContext)context).getContextClass();
        ValueResolverContext currentContext = null;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (!(currentType instanceof IJavaClassType)) {
                if (tokenizer.hasMoreTokens()) {
                    return true;
                }
                ((ValueResolverContext)context).setResultType(currentType);
                if (currentContext != null) {
                    ((ValueResolverContext)context).setResultCodeBind(currentContext.getResultCodeBind());
                }
                return true;
            }
            currentContext = new ValueResolverContext(((ValueResolverContext)context).getProject(), (IJavaClassType)currentType, token, PREFIX);
            if (_normalCasesChain.execute((Context)currentContext)) {
                currentType = currentContext.getResultType();
                continue;
            }
            return false;
        }
        ((ValueResolverContext)context).setResultType(currentType);
        if (currentContext != null) {
            ((ValueResolverContext)context).setResultCodeBind(currentContext.getResultCodeBind());
        }
        return true;
    }
}

