/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tapestry.core;

import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.impl.java.stubs.index.JavaAnnotationIndex;
import com.intellij.psi.impl.java.stubs.index.JavaMethodNameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.tapestry.core.ElementsCachedMap;
import com.intellij.tapestry.core.MappingDataCache;
import com.intellij.tapestry.core.events.TapestryEventsManager;
import com.intellij.tapestry.core.java.IJavaClassType;
import com.intellij.tapestry.core.java.IJavaTypeCreator;
import com.intellij.tapestry.core.java.IJavaTypeFinder;
import com.intellij.tapestry.core.model.Library;
import com.intellij.tapestry.core.model.presentation.Component;
import com.intellij.tapestry.core.model.presentation.Mixin;
import com.intellij.tapestry.core.model.presentation.Page;
import com.intellij.tapestry.core.model.presentation.PresentationLibraryElement;
import com.intellij.tapestry.core.model.presentation.components.BlockComponent;
import com.intellij.tapestry.core.model.presentation.components.BodyComponent;
import com.intellij.tapestry.core.model.presentation.components.ContainerComponent;
import com.intellij.tapestry.core.model.presentation.components.ParameterComponent;
import com.intellij.tapestry.core.resource.IResource;
import com.intellij.tapestry.core.resource.IResourceFinder;
import com.intellij.tapestry.core.util.LocalizationUtils;
import com.intellij.tapestry.core.util.StringUtils;
import com.intellij.tapestry.intellij.facet.TapestryFacet;
import com.intellij.tapestry.intellij.facet.TapestryFacetConfiguration;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TapestryProject {
    public static final Object[] JAVA_STRUCTURE_DEPENDENCY = new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT};
    public static final Object[] OUT_OF_CODE_BLOCK_DEPENDENCY = new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT};
    public static final String APPLICATION_LIBRARY_ID = "application";
    public static final String CORE_LIBRARY_ID = "core";
    private final Library myCoreLibrary;
    private final Module myModule;
    private final IResourceFinder myResourceFinder;
    private Collection<Library> myCachedLibraries;
    private Map<String, List<String>> myCachedLibraryMapping;
    private volatile String myLastApplicationPackage;
    private String myLastApplicationFilterName;
    private final IJavaTypeFinder myJavaTypeFinder;
    private final IJavaTypeCreator myJavaTypeCreator;
    private final TapestryEventsManager myEventsManager;
    private final MappingDataCache mappingData;
    private static final ElementsCachedMap ourNameToPageMap = new ElementsCachedMap("ourNameToPageMap", false, true, false){

        @Override
        protected String computeKey(PresentationLibraryElement element) {
            return element.getName().toLowerCase();
        }
    };
    private static final ElementsCachedMap ourFqnToPageMap = new ElementsCachedMap("ourFqnToPageMap", false, true, false){

        @Override
        protected String computeKey(PresentationLibraryElement element) {
            return element.getElementClass().getFullyQualifiedName();
        }
    };
    private static final ElementsCachedMap ourNameToComponentMap = new ElementsCachedMap("ourNameToComponentMap", true, false, false){

        @Override
        protected String computeKey(PresentationLibraryElement element) {
            return element.getName().toLowerCase();
        }
    };
    private static final ElementsCachedMap ourNameToMixinMap = new ElementsCachedMap("ourNameToMixinMap", false, false, true){

        @Override
        protected String computeKey(PresentationLibraryElement element) {
            return element.getName().toLowerCase();
        }
    };
    private static final ElementsCachedMap ourFqnToComponentMap = new ElementsCachedMap("ourFqnToComponentMap", true, false, false){

        @Override
        protected String computeKey(PresentationLibraryElement element) {
            return element.getElementClass().getFullyQualifiedName();
        }
    };
    private static final ElementsCachedMap ourTemplateToElementMap = new ElementsCachedMap("ourTemplateToElementMap", true, true, false, true){

        @Override
        @Nullable
        protected String computeKey(PresentationLibraryElement element) {
            IResource[] resources = element.getTemplate();
            return resources.length > 0 ? LocalizationUtils.unlocalizeFileName(resources[0].getFile().getAbsolutePath()) : null;
        }
    };

    public TapestryProject(@NotNull Module module, @NotNull IResourceFinder resourceFinder, @NotNull IJavaTypeFinder javaTypeFinder, @NotNull IJavaTypeCreator javaTypeCreator) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/tapestry/core/TapestryProject", "<init>"));
        }
        if (resourceFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceFinder", "com/intellij/tapestry/core/TapestryProject", "<init>"));
        }
        if (javaTypeFinder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaTypeFinder", "com/intellij/tapestry/core/TapestryProject", "<init>"));
        }
        if (javaTypeCreator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "javaTypeCreator", "com/intellij/tapestry/core/TapestryProject", "<init>"));
        }
        this.myCoreLibrary = new Library(CORE_LIBRARY_ID, "org.apache.tapestry5.corelib", this);
        this.mappingData = new MappingDataCache();
        this.myModule = module;
        this.myResourceFinder = resourceFinder;
        this.myJavaTypeFinder = javaTypeFinder;
        this.myJavaTypeCreator = javaTypeCreator;
        this.myEventsManager = new TapestryEventsManager();
        this.myLastApplicationPackage = null;
        this.myLastApplicationFilterName = null;
    }

    @Nullable
    public String getApplicationRootPackage() {
        TapestryFacetConfiguration myConfiguration = TapestryFacet.findFacetConfiguration(this.myModule);
        return myConfiguration == null ? null : myConfiguration.getApplicationPackage();
    }

    @Nullable
    public String getApplicationFilterName() {
        TapestryFacetConfiguration myConfiguration = TapestryFacet.findFacetConfiguration(this.myModule);
        return myConfiguration == null ? null : myConfiguration.getFilterName();
    }

    @Nullable
    public String getPagesRootPackage() {
        return this.getElementsRootPackage("pages");
    }

    @Nullable
    public String getComponentsRootPackage() {
        return this.getElementsRootPackage("components");
    }

    @Nullable
    public String getMixinsRootPackage() {
        return this.getElementsRootPackage("mixins");
    }

    @Nullable
    private String getElementsRootPackage(@NotNull String subpackage) {
        if (subpackage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "subpackage", "com/intellij/tapestry/core/TapestryProject", "getElementsRootPackage"));
        }
        String rootPackage = this.getApplicationRootPackage();
        if (rootPackage == null) {
            return null;
        }
        return rootPackage + "." + subpackage;
    }

    @NotNull
    public Collection<Library> getLibraries() {
        String applicationRootPackage = this.getApplicationRootPackage();
        String applicationFilterName = this.getApplicationFilterName();
        if (applicationRootPackage == null) {
            List<Library> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/core/TapestryProject", "getLibraries"));
            }
            return list;
        }
        Map<String, List<String>> libraryMapping = this.findLibraryMapping();
        if (StringUtils.isNotEmpty(this.myLastApplicationPackage) && StringUtils.isNotEmpty(this.myLastApplicationFilterName) && this.myCachedLibraries != null && this.myLastApplicationPackage.equals(applicationRootPackage) && this.myLastApplicationFilterName.equals(applicationFilterName) && libraryMapping.equals(this.myCachedLibraryMapping)) {
            Collection<Library> collection = this.myCachedLibraries;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/core/TapestryProject", "getLibraries"));
            }
            return collection;
        }
        ArrayList<Library> cachedLibraries = new ArrayList<Library>();
        cachedLibraries.add(new Library(APPLICATION_LIBRARY_ID, applicationRootPackage, this));
        cachedLibraries.add(new Library(APPLICATION_LIBRARY_ID, applicationRootPackage + "." + applicationFilterName, this));
        cachedLibraries.add(this.myCoreLibrary);
        for (String libraryShortName : libraryMapping.keySet()) {
            for (String baseProject : libraryMapping.get(libraryShortName)) {
                boolean coreLibrary = CORE_LIBRARY_ID.equals(libraryShortName);
                cachedLibraries.add(new Library(APPLICATION_LIBRARY_ID, baseProject, this, coreLibrary ? null : libraryShortName));
            }
        }
        this.myCachedLibraries = cachedLibraries;
        this.myCachedLibraryMapping = libraryMapping;
        this.myLastApplicationFilterName = applicationFilterName;
        this.myLastApplicationPackage = applicationRootPackage;
        ArrayList<Library> arrayList = cachedLibraries;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/core/TapestryProject", "getLibraries"));
        }
        return arrayList;
    }

    @Nullable
    public Library getApplicationLibrary() {
        Collection<Library> libraries = this.getLibraries();
        return libraries.size() == 0 ? null : libraries.iterator().next();
    }

    @Nullable
    public Page findPage(String pageName) {
        return (Page)((Map)ourNameToPageMap.get(this.myModule)).get(pageName.toLowerCase());
    }

    @NotNull
    public String[] getAvailablePageNames() {
        Set names = ((Map)ourNameToPageMap.get(this.myModule)).keySet();
        String[] stringArray = ArrayUtil.toStringArray(names);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/core/TapestryProject", "getAvailablePageNames"));
        }
        return stringArray;
    }

    @Nullable
    public Page findPage(@NotNull IJavaClassType pageClass) {
        if (pageClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pageClass", "com/intellij/tapestry/core/TapestryProject", "findPage"));
        }
        return (Page)((Map)ourFqnToPageMap.get(this.myModule)).get(pageClass.getFullyQualifiedName());
    }

    @Nullable
    public Component findComponent(@NotNull String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/tapestry/core/TapestryProject", "findComponent"));
        }
        return (Component)((Map)ourNameToComponentMap.get(this.myModule)).get(componentName.toLowerCase());
    }

    @Nullable
    public Mixin findMixin(String mixinName) {
        return (Mixin)((Map)ourNameToMixinMap.get(this.myModule)).get(mixinName.toLowerCase());
    }

    @NotNull
    private Map<String, List<String>> findLibraryMapping() {
        THashMap result = new THashMap();
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule);
        for (PsiMethod psiMethod : JavaMethodNameIndex.getInstance().get("contributeComponentClassResolver", this.myModule.getProject(), scope)) {
            TapestryProject.addFromMappingData((Map<String, List<String>>)result, (Map)this.mappingData.compute(psiMethod.getContainingFile()));
        }
        Collection annotations = JavaAnnotationIndex.getInstance().get("Contribute", this.myModule.getProject(), scope);
        for (PsiAnnotation annotation : annotations) {
            PsiAnnotationMemberValue value;
            PsiNameValuePair[] attributes = annotation.getParameterList().getAttributes();
            if (attributes.length != 1 || !((value = attributes[0].getValue()) instanceof PsiClassObjectAccessExpression) || !"ComponentClassResolver".equals(((PsiClassObjectAccessExpression)value).getOperand().getText())) continue;
            TapestryProject.addFromMappingData((Map<String, List<String>>)result, (Map)this.mappingData.compute(annotation.getContainingFile()));
        }
        THashMap tHashMap = result;
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/core/TapestryProject", "findLibraryMapping"));
        }
        return tHashMap;
    }

    private static void addFromMappingData(Map<String, List<String>> result, Map<String, String> computedMap) {
        for (String key : computedMap.keySet()) {
            List<String> strings = result.get(key);
            if (strings == null) {
                strings = new ArrayList<String>(2);
                result.put(key, strings);
            }
            strings.add(computedMap.get(key));
        }
    }

    @NotNull
    public String[] getAvailableComponentNames() {
        Set names = ((Map)ourNameToComponentMap.get(this.myModule)).keySet();
        String[] stringArray = ArrayUtil.toStringArray(names);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/core/TapestryProject", "getAvailableComponentNames"));
        }
        return stringArray;
    }

    public Collection<PresentationLibraryElement> getBuiltinComponents() {
        return Arrays.asList(BodyComponent.getInstance(this), BlockComponent.getInstance(this), ParameterComponent.getInstance(this), ContainerComponent.getInstance(this));
    }

    public Collection<PresentationLibraryElement> getBuiltinPages() {
        return Collections.emptyList();
    }

    @Nullable
    public PresentationLibraryElement findElement(@NotNull IJavaClassType elementClass) {
        if (elementClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementClass", "com/intellij/tapestry/core/TapestryProject", "findElement"));
        }
        Component component = this.findComponent(elementClass);
        return component != null ? component : this.findPage(elementClass);
    }

    @Nullable
    public Component findComponent(@NotNull IJavaClassType componentClass) {
        if (componentClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentClass", "com/intellij/tapestry/core/TapestryProject", "findComponent"));
        }
        return (Component)((Map)ourFqnToComponentMap.get(this.myModule)).get(componentClass.getFullyQualifiedName());
    }

    @Nullable
    public PresentationLibraryElement findElementByTemplate(@NotNull PsiFile template) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/tapestry/core/TapestryProject", "findElementByTemplate"));
        }
        String templatePath = new File(template.getOriginalFile().getViewProvider().getVirtualFile().getPath()).getAbsolutePath();
        return (PresentationLibraryElement)((Map)ourTemplateToElementMap.get(this.myModule)).get(LocalizationUtils.unlocalizeFileName(templatePath));
    }

    @NotNull
    public Collection<PresentationLibraryElement> getAvailableElements() {
        Collection<PresentationLibraryElement> collection = ((Map)ourFqnToComponentMap.get(this.myModule)).values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/core/TapestryProject", "getAvailableElements"));
        }
        return collection;
    }

    @NotNull
    public IJavaTypeFinder getJavaTypeFinder() {
        IJavaTypeFinder iJavaTypeFinder = this.myJavaTypeFinder;
        if (iJavaTypeFinder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/core/TapestryProject", "getJavaTypeFinder"));
        }
        return iJavaTypeFinder;
    }

    @NotNull
    public IJavaTypeCreator getJavaTypeCreator() {
        IJavaTypeCreator iJavaTypeCreator = this.myJavaTypeCreator;
        if (iJavaTypeCreator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/core/TapestryProject", "getJavaTypeCreator"));
        }
        return iJavaTypeCreator;
    }

    public IResourceFinder getResourceFinder() {
        return this.myResourceFinder;
    }

    @NotNull
    public TapestryEventsManager getEventsManager() {
        TapestryEventsManager tapestryEventsManager = this.myEventsManager;
        if (tapestryEventsManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tapestry/core/TapestryProject", "getEventsManager"));
        }
        return tapestryEventsManager;
    }
}

