/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph.editor;

import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.jsf.yfilesGraph.FacesPageGraphComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacesPageFileEditor
extends PerspectiveFileEditor {
    protected FacesPageGraphComponent myFacesPageComponent;
    private final FacesConfig myFacesConfig;

    public FacesPageFileEditor(Project project, @NotNull VirtualFile file, @NotNull FacesConfig facesConfig) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/yfilesGraph/editor/FacesPageFileEditor", "<init>"));
        }
        if (facesConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facesConfig", "com/intellij/jsf/yfilesGraph/editor/FacesPageFileEditor", "<init>"));
        }
        super(project, file);
        this.myFacesConfig = facesConfig;
        this.assertFile(project, file);
    }

    public FacesPageGraphComponent getFacesPageComponent() {
        assert (this.myFacesPageComponent != null);
        return this.myFacesPageComponent;
    }

    private FacesPageGraphComponent createComponent() {
        GenericValue<PathReference> pathReference = JsfCommonUtils.getViewId(this.getFacesConfig(), this.getVirtualFile());
        String viewId = pathReference != null ? pathReference.getStringValue() : this.getVirtualFile().getName();
        return new FacesPageGraphComponent(this.getFacesConfig(), viewId);
    }

    private FacesConfig getFacesConfig() {
        return this.myFacesConfig;
    }

    protected void assertFile(Project project, VirtualFile file) {
    }

    @Nullable
    protected DomElement getSelectedDomElement() {
        return null;
    }

    protected void setSelectedDomElement(DomElement domElement) {
    }

    public void commit() {
    }

    public void reset() {
        this.getFacesPageComponent().getBuilder().updateGraph();
    }

    @NotNull
    public String getName() {
        String string = FacesBundle.message("editor.tab.faces.navigation.y", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/yfilesGraph/editor/FacesPageFileEditor", "getName"));
        }
        return string;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return ((Graph2DView)this.myFacesPageComponent.getBuilder().getGraph().getCurrentView()).getJComponent();
    }

    @NotNull
    protected JComponent createCustomComponent() {
        if (this.myFacesPageComponent == null) {
            this.myFacesPageComponent = this.createComponent();
            Disposer.register((Disposable)this, (Disposable)this.myFacesPageComponent);
        }
        FacesPageGraphComponent facesPageGraphComponent = this.myFacesPageComponent;
        if (facesPageGraphComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/yfilesGraph/editor/FacesPageFileEditor", "createCustomComponent"));
        }
        return facesPageGraphComponent;
    }
}

