/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph.dnd;

import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.dnd.ProjectViewDnDSupport;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BasicWebFacetProjectViewDnDSupport<N, E>
implements ProjectViewDnDSupport<N, PsiFile> {
    private final GraphBuilder<N, E> myBuilder;
    private final WebFacet myFacetScope;

    public BasicWebFacetProjectViewDnDSupport(GraphBuilder<N, E> builder, @NotNull WebFacet facetScope) {
        if (facetScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetScope", "com/intellij/jsf/yfilesGraph/dnd/BasicWebFacetProjectViewDnDSupport", "<init>"));
        }
        this.myBuilder = builder;
        this.myFacetScope = facetScope;
    }

    public boolean acceptDraggedElements(@NotNull List<PsiFile> draggedFiles) {
        if (draggedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "draggedFiles", "com/intellij/jsf/yfilesGraph/dnd/BasicWebFacetProjectViewDnDSupport", "acceptDraggedElements"));
        }
        for (PsiFile draggedFile : draggedFiles) {
            if (this.acceptDraggedFile(draggedFile)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public List<N> dropElements(@NotNull List<PsiFile> list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/jsf/yfilesGraph/dnd/BasicWebFacetProjectViewDnDSupport", "dropElements"));
        }
        ArrayList<N> nodeObjects = new ArrayList<N>();
        for (PsiFile file : list) {
            N nodeObject;
            String webPath = WebUtil.getWebUtil().getWebPath(file);
            if (webPath == null || (nodeObject = this.createNodeObject(webPath)) == null) continue;
            nodeObjects.add(nodeObject);
        }
        ArrayList<N> arrayList = nodeObjects;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/yfilesGraph/dnd/BasicWebFacetProjectViewDnDSupport", "dropElements"));
        }
        return arrayList;
    }

    protected boolean acceptDraggedFile(PsiFile psiFile) {
        return this.myFacetScope.equals((Object)WebUtil.getWebFacet((PsiElement)psiFile)) && WebUtil.isInsideWebRoots((VirtualFile)psiFile.getVirtualFile(), (Project)psiFile.getProject()) && !this.isExistNode(psiFile);
    }

    protected boolean isExistNode(PsiFile psiFile) {
        String webPath = WebUtil.getWebUtil().getWebPath(psiFile);
        if (webPath != null) {
            for (Node node : this.myBuilder.getGraph().getNodeArray()) {
                Object nodeObject = this.myBuilder.getNodeObject(node);
                if (nodeObject == null || !this.areNodesEquals(webPath, nodeObject)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected abstract N createNodeObject(@NotNull String var1);

    protected abstract boolean areNodesEquals(@NotNull String var1, @NotNull N var2);
}

