/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.toolWindow.tree.nodes;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jam.JamMessages;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsfModelElementNode<T>
extends SimpleNode {
    private T myElement;

    public JsfModelElementNode(Project project, NodeDescriptor parentDescriptor, T element) {
        super(project, parentDescriptor);
        this.myElement = element;
    }

    @NotNull
    protected String getNodeText() {
        if (!this.isValid()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/toolWindow/tree/nodes/JsfModelElementNode", "getNodeText"));
            }
            return "";
        }
        String name = this.getActualNodeName();
        String string = StringUtil.isEmptyOrSpaces((String)name) ? JamMessages.message((String)"unnamed.element.presentable.name", (Object[])new Object[0]) : name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/toolWindow/tree/nodes/JsfModelElementNode", "getNodeText"));
        }
        return string;
    }

    @Nullable
    protected String getNodeTextExt() {
        return null;
    }

    @Nullable
    protected String getActualNodeName() {
        return null;
    }

    public abstract boolean isValid();

    protected void doUpdate() {
        if (!this.isValid()) {
            return;
        }
        String nodeText = this.getNodeText();
        this.setNodeText(nodeText, null, !this.isValid());
        String textExt = this.getNodeTextExt();
        if (textExt != null) {
            this.addColoredFragment(" (" + this.getNodeTextExt() + ")", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    public SimpleNode[] getChildren() {
        return NO_CHILDREN;
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.myElement};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/toolWindow/tree/nodes/JsfModelElementNode", "getEqualityObjects"));
        }
        return objectArray;
    }

    public T getModelElement() {
        return this.myElement;
    }
}

