/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.schemas;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlSchemaProvider;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsfSchemaProvider
extends XmlSchemaProvider {
    public XmlFile getSchema(@NotNull @NonNls String url, @Nullable Module module, @NotNull PsiFile baseFile) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/jsf/schemas/JsfSchemaProvider", "getSchema"));
        }
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/jsf/schemas/JsfSchemaProvider", "getSchema"));
        }
        String location = this.getLibs().get(url);
        if (location != null) {
            return this.getBundledSchema(location, baseFile);
        }
        return null;
    }

    @NotNull
    public abstract Map<String, String> getLibs();

    @Nullable
    public XmlFile getBundledSchema(String fileName, PsiFile baseFile) {
        URL resource = this.getSchemaResource(fileName);
        VirtualFile virtualFile = VfsUtil.findFileByURL((URL)resource);
        PsiFile psiFile = baseFile.getManager().findFile(virtualFile);
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    @NotNull
    protected abstract URL getSchemaResource(@NotNull String var1);

    @NotNull
    public Set<String> getAvailableNamespaces(@NotNull XmlFile file, String tagName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/schemas/JsfSchemaProvider", "getAvailableNamespaces"));
        }
        Set<String> set = this.getLibs().keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/schemas/JsfSchemaProvider", "getAvailableNamespaces"));
        }
        return set;
    }
}

