/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references;

import com.intellij.jsf.references.JsfXmlAttributeReferencesProvider;
import com.intellij.jsf.references.contracts.JsfContractPsiReference;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.filters.AndFilter;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.filters.TextFilter;
import com.intellij.psi.filters.XmlTagFilter;
import com.intellij.psi.filters.position.NamespaceFilter;
import com.intellij.psi.filters.position.ParentElementFilter;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import com.intellij.xml.util.XmlUtil;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JsfViewContractsAttributeReferencesProvider
extends JsfXmlAttributeReferencesProvider {
    @NonNls
    private static final String JSF_CONTRACT_ATTR_NAME = "contracts";

    @Override
    public String[] getAttributeNames() {
        return new String[]{JSF_CONTRACT_ATTR_NAME};
    }

    @Override
    protected PsiReference[] createReferences(@NotNull XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
        if (xmlAttributeValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttributeValue", "com/intellij/jsf/references/JsfViewContractsAttributeReferencesProvider", "createReferences"));
        }
        String value = xmlAttributeValue.getValue();
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)xmlAttributeValue);
        if (module == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        Set<PsiDirectory> directories = JsfCommonUtils.getContractsDirectories(module);
        if (directories.size() == 0) {
            return PsiReference.EMPTY_ARRAY;
        }
        return new PsiReference[]{new JsfContractPsiReference((PsiElement)xmlAttributeValue, directories)};
    }

    @Override
    public ElementFilter getElementFilter() {
        return new ParentElementFilter((ElementFilter)new AndFilter((ElementFilter)new AndFilter((ElementFilter)XmlTagFilter.INSTANCE, (ElementFilter)new TextFilter("view")), (ElementFilter)new NamespaceFilter(XmlUtil.JSF_CORE_URIS)), 2);
    }
}

