/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references;

import com.intellij.jsf.references.JsfResourceDirectoryReference;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.ReferenceSetBase;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JsfResourceIdentifierReferenceSet
extends ReferenceSetBase<JsfResourceDirectoryReference> {
    public JsfResourceIdentifierReferenceSet(@NotNull PsiElement element, @NotNull String text) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/references/JsfResourceIdentifierReferenceSet", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/jsf/references/JsfResourceIdentifierReferenceSet", "<init>"));
        }
        this(element, text, '/', 1);
    }

    public JsfResourceIdentifierReferenceSet(@NotNull PsiElement element, @NotNull String text, char separator, int offset) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/references/JsfResourceIdentifierReferenceSet", "<init>"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/jsf/references/JsfResourceIdentifierReferenceSet", "<init>"));
        }
        super(text, element, offset, separator);
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    protected List<JsfResourceDirectoryReference> parse(String str, int offset) {
        List list = super.parse(str, offset);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfResourceIdentifierReferenceSet", "parse"));
        }
        return list;
    }

    protected int findNextSeparator(String str, int current) {
        PsiDirectory directory;
        if (current == -1 && str.contains(".") && (directory = this.getDottedDirectoriesFromMetaInf(str)) != null) {
            current += directory.getName().length();
        }
        return super.findNextSeparator(str, current);
    }

    @NotNull
    protected JsfResourceDirectoryReference createReference(TextRange range, int index) {
        JsfResourceDirectoryReference jsfResourceDirectoryReference = new JsfResourceDirectoryReference(this, range, index);
        if (jsfResourceDirectoryReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfResourceIdentifierReferenceSet", "createReference"));
        }
        return jsfResourceDirectoryReference;
    }

    public PsiDirectory getDottedDirectoriesFromMetaInf(String str) {
        for (PsiDirectory resourceDirectory : JsfCommonUtils.getMetaInfResources(ModuleUtil.findModuleForPsiElement((PsiElement)this.getElement()))) {
            for (PsiDirectory psiDirectory : resourceDirectory.getSubdirectories()) {
                String name = psiDirectory.getName();
                if (!name.contains(".") || !str.startsWith(name)) continue;
                return psiDirectory;
            }
        }
        return null;
    }

    @NotNull
    public Set<PsiDirectory> getResourceLibraryDirectories() {
        Set<PsiDirectory> set = JsfCommonUtils.getTopLevelResourcesDirectories(ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement()));
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfResourceIdentifierReferenceSet", "getResourceLibraryDirectories"));
        }
        return set;
    }

    public Set<PsiDirectory> getLibraries() {
        HashSet<PsiDirectory> set = new HashSet<PsiDirectory>();
        JsfResourceDirectoryReference lastReference = (JsfResourceDirectoryReference)this.getLastReference();
        if (lastReference != null) {
            ResolveResult[] results;
            for (ResolveResult resolveResult : results = lastReference.multiResolve(false)) {
                PsiElement psiElement = resolveResult.getElement();
                if (!(psiElement instanceof PsiDirectory)) continue;
                set.add((PsiDirectory)psiElement);
            }
        }
        return set;
    }
}

