/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.references;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.ide.highlighter.JspxFileType;
import com.intellij.javaee.web.WebUtil;
import com.intellij.jsf.references.ActionAttributeValueReference;
import com.intellij.jsf.references.JsfXmlAttributeReferencesProvider;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.jsp.WebDirectoryElement;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfActionXmlAttributeReferencesProvider
extends JsfXmlAttributeReferencesProvider {
    @NonNls
    private static final String JSF_ACTION_ATTR_NAME = "action";
    private static final String[] myParamVariants = new String[]{"faces-redirect=true", "faces-redirect=false"};

    @Override
    public String[] getAttributeNames() {
        return new String[]{JSF_ACTION_ATTR_NAME};
    }

    @Override
    protected PsiReference[] createReferences(@NotNull XmlAttributeValue element, ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider", "createReferences"));
        }
        String value = element.getValue();
        if (StringUtil.isEmptyOrSpaces((String)value)) {
            return PsiReference.EMPTY_ARRAY;
        }
        if (value.trim().startsWith("/")) {
            return PathReferenceManager.getInstance().createCustomReferences((PsiElement)element, true, new PathReferenceProvider[]{new CustomReferneceProvider(), new RedirectParamPathReferenceProvider()});
        }
        ActionAttributeValueReference simpleAttributeValueReference = new ActionAttributeValueReference((PsiElement)element);
        PsiReference redirectParamPathReference = JsfActionXmlAttributeReferencesProvider.createRedirectParamPathReference((PsiElement)element);
        if (redirectParamPathReference != null) {
            return new PsiReference[]{simpleAttributeValueReference, redirectParamPathReference};
        }
        return new PsiReference[]{simpleAttributeValueReference};
    }

    @Nullable
    private static String getValue(PsiElement psiElement) {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)psiElement);
        if (manipulator != null) {
            return manipulator.getRangeInElement(psiElement).substring(psiElement.getText());
        }
        return null;
    }

    @Nullable
    public static PsiReference createRedirectParamPathReference(final @NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider", "createRedirectParamPathReference"));
        }
        String value = JsfActionXmlAttributeReferencesProvider.getValue(psiElement);
        if (value != null && value.contains("?")) {
            String paramValue = value.substring(value.indexOf("?"));
            return new PsiReferenceBase<PsiElement>(psiElement, TextRange.from((int)(psiElement.getText().indexOf("?") + 1), (int)(paramValue.length() - 1)), false){

                public PsiElement resolve() {
                    return psiElement;
                }

                @NotNull
                public Object[] getVariants() {
                    Object[] objectArray = myParamVariants;
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider$1", "getVariants"));
                    }
                    return objectArray;
                }
            };
        }
        return null;
    }

    private class CustomReferneceProvider
    implements PathReferenceProvider {
        private CustomReferneceProvider() {
        }

        public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider$CustomReferneceProvider", "createReferences"));
            }
            if (references == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider$CustomReferneceProvider", "createReferences"));
            }
            ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)psiElement);
            TextRange range = manipulator.getRangeInElement(psiElement);
            int offset = range.getStartOffset();
            String text = range.substring(psiElement.getText());
            String trimedUrl = WebUtil.trimURL((String)text);
            FileReferenceSet set = new FileReferenceSet(trimedUrl, psiElement, offset, null, true, true){

                protected boolean isSoft() {
                    return true;
                }

                public FileReference createFileReference(TextRange range, int index, String text) {
                    return new ActionAttrFileReference(range, index, text, this);
                }

                protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                    return element -> element instanceof WebDirectoryElement || element instanceof PsiFile && ((PsiFile)element).getFileType() instanceof JspxFileType;
                }
            };
            Collections.addAll(references, set.getAllReferences());
            return false;
        }

        @Nullable
        public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider$CustomReferneceProvider", "getPathReference"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider$CustomReferneceProvider", "getPathReference"));
            }
            return null;
        }

        public class ActionAttrFileReference
        extends FileReference {
            public ActionAttrFileReference(TextRange range, int index, String text, FileReferenceSet set) {
                super(set, range, index, text);
            }

            public void innerResolveInContext(@NotNull String text, @NotNull PsiFileSystemItem context, Collection<ResolveResult> result, boolean caseSensitive) {
                if (text == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider$CustomReferneceProvider$ActionAttrFileReference", "innerResolveInContext"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider$CustomReferneceProvider$ActionAttrFileReference", "innerResolveInContext"));
                }
                super.innerResolveInContext(this.isLast() ? text + ".xhtml" : text, context, result, caseSensitive);
            }

            protected Object createLookupItem(PsiElement candidate) {
                if (candidate instanceof PsiFile) {
                    PsiFile file = (PsiFile)candidate;
                    String nameWithoutExtension = FileUtil.getNameWithoutExtension((String)file.getName());
                    return LookupElementBuilder.create((String)nameWithoutExtension).withIcon(file.getIcon(0)).withTypeText(file.getName());
                }
                return super.createLookupItem(candidate);
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                if (newElementName.contains(".")) {
                    newElementName = newElementName.substring(0, newElementName.indexOf("."));
                }
                return super.handleElementRename(newElementName);
            }

            protected PsiElement rename(String newName) throws IncorrectOperationException {
                if (newName.contains(".")) {
                    newName = newName.substring(0, newName.indexOf("."));
                }
                return super.rename(newName);
            }
        }
    }

    private static class RedirectParamPathReferenceProvider
    implements PathReferenceProvider {
        private RedirectParamPathReferenceProvider() {
        }

        public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider$RedirectParamPathReferenceProvider", "createReferences"));
            }
            if (references == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider$RedirectParamPathReferenceProvider", "createReferences"));
            }
            PsiReference pathReference = JsfActionXmlAttributeReferencesProvider.createRedirectParamPathReference(psiElement);
            if (pathReference != null) {
                references.add(pathReference);
            }
            return false;
        }

        public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider$RedirectParamPathReferenceProvider", "getPathReference"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/references/JsfActionXmlAttributeReferencesProvider$RedirectParamPathReferenceProvider", "getPathReference"));
            }
            return null;
        }
    }
}

