/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.providers.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.WebFileReferenceHelper;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class WebFileReferenceHelperForPsiClasses
extends WebFileReferenceHelper {
    private static final Set<String> resourceAnnotations = new HashSet();

    public boolean isMine(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/providers/jam/WebFileReferenceHelperForPsiClasses", "isMine"));
        }
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null) {
            return false;
        }
        if (file.getFileType() == StdFileTypes.JAVA && JsfCommonUtils.isJsfSupported(module)) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
            boolean flowSupported = JsfCommonUtils.isFlowSupported(module);
            Set<String> flowAnnotation = Collections.singleton("javax.faces.flow.builder.FlowDefinition");
            if (psiFile instanceof PsiJavaFile) {
                PsiJavaFile psiJavaFile = (PsiJavaFile)psiFile;
                for (PsiClass psiClass : psiJavaFile.getClasses()) {
                    if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, resourceAnnotations)) {
                        return true;
                    }
                    if (!flowSupported) continue;
                    for (PsiMethod method : psiClass.getMethods()) {
                        if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)method, flowAnnotation)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private static Collection<WebFacet> getWebFacets(Project project, VirtualFile file) {
        Module module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)project);
        if (module != null) {
            return WebFacet.getInstances((Module)module);
        }
        return Collections.emptyList();
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/providers/jam/WebFileReferenceHelperForPsiClasses", "getContexts"));
        }
        ArrayList<PsiFileSystemItem> items = new ArrayList<PsiFileSystemItem>();
        for (WebFacet webFacet : WebFileReferenceHelperForPsiClasses.getWebFacets(project, file)) {
            for (WebRoot webRoot : webFacet.getWebRoots(true)) {
                VirtualFile virtualFile = webRoot.getFile();
                if (virtualFile == null) continue;
                items.add((PsiFileSystemItem)PsiManager.getInstance((Project)project).findDirectory(virtualFile));
            }
        }
        ArrayList<PsiFileSystemItem> arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/providers/jam/WebFileReferenceHelperForPsiClasses", "getContexts"));
        }
        return arrayList;
    }

    static {
        resourceAnnotations.add("javax.faces.application.ResourceDependency");
        resourceAnnotations.add("javax.faces.application.ResourceDependencies");
    }
}

