/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.providers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PathListReferenceProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class FaceletLabrariesPathListProvider
extends PathListReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/providers/FaceletLabrariesPathListProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jsf/providers/FaceletLabrariesPathListProvider", "getReferencesByElement"));
        }
        if (FaceletLabrariesPathListProvider.isFaceletLabraries(element)) {
            PsiReference[] psiReferenceArray = super.getReferencesByElement(element, context);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/providers/FaceletLabrariesPathListProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/providers/FaceletLabrariesPathListProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static boolean isFaceletLabraries(PsiElement element) {
        String paramName;
        XmlTag nameTag;
        XmlTag parent = ((XmlTag)element).getParentTag();
        return parent != null && parent.getName().equals("context-param") && (nameTag = parent.findFirstSubTag("param-name")) != null && (paramName = nameTag.getValue().getText()).equals("javax.faces.FACELETS_LIBRARIES");
    }

    protected char getSeparator() {
        return ';';
    }
}

