/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.model.xml.flows.converters;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.paths.StaticPathReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.converters.PathReferenceConverter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowsPathReferenceConverter
extends PathReferenceConverter {
    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/jsf/model/xml/flows/converters/FlowsPathReferenceConverter", "createReferences"));
        }
        PsiReference[] psiReferenceArray = PathReferenceManager.getInstance().createReferences(psiElement, soft, new PathReferenceProvider[]{new MetaInfFlowsPathReferenceProvider()});
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/model/xml/flows/converters/FlowsPathReferenceConverter", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static class MetaInfFlowsPathReferenceProvider
    extends StaticPathReferenceProvider {
        public MetaInfFlowsPathReferenceProvider() {
            super(null);
        }

        public boolean createReferences(@NotNull PsiElement psiElement, int offset, String text, @NotNull List<PsiReference> references, boolean soft) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/jsf/model/xml/flows/converters/FlowsPathReferenceConverter$MetaInfFlowsPathReferenceProvider", "createReferences"));
            }
            if (references == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "references", "com/intellij/jsf/model/xml/flows/converters/FlowsPathReferenceConverter$MetaInfFlowsPathReferenceProvider", "createReferences"));
            }
            FileReferenceSet set = new FileReferenceSet(text, psiElement, offset, null, true, false, null){

                protected boolean isUrlEncoded() {
                    return true;
                }

                @NotNull
                public Collection<PsiFileSystemItem> getDefaultContexts() {
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
                    if (module != null) {
                        HashSet directories = new HashSet();
                        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
                            PsiDirectory directory;
                            VirtualFile flows;
                            VirtualFile metaInf = root.findChild("META-INF");
                            if (metaInf == null || (flows = metaInf.findChild("flows")) == null || (directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(flows)) == null) continue;
                            directories.add(directory);
                        }
                        HashSet hashSet = directories;
                        if (hashSet == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/model/xml/flows/converters/FlowsPathReferenceConverter$MetaInfFlowsPathReferenceProvider$1", "getDefaultContexts"));
                        }
                        return hashSet;
                    }
                    Collection collection = super.getDefaultContexts();
                    if (collection == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/model/xml/flows/converters/FlowsPathReferenceConverter$MetaInfFlowsPathReferenceProvider$1", "getDefaultContexts"));
                    }
                    return collection;
                }

                protected boolean isSoft() {
                    return true;
                }
            };
            Collections.addAll(references, set.getAllReferences());
            return true;
        }

        @Nullable
        public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/jsf/model/xml/flows/converters/FlowsPathReferenceConverter$MetaInfFlowsPathReferenceProvider", "getPathReference"));
            }
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jsf/model/xml/flows/converters/FlowsPathReferenceConverter$MetaInfFlowsPathReferenceProvider", "getPathReference"));
            }
            return null;
        }
    }
}

