/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.model.jam;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jsf.model.jam.JsfJamComponent;
import com.intellij.jsf.model.jam.JsfJamConverter;
import com.intellij.jsf.model.jam.JsfJamManagedBean;
import com.intellij.jsf.model.jam.JsfJamRenderer;
import com.intellij.jsf.model.jam.JsfJamValidator;
import com.intellij.jsf.model.jam.event.JsfJamListenerFor;
import com.intellij.jsf.model.jam.event.JsfJamListenersFor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsfJamModel {
    private final Module myModule;

    public static JsfJamModel getModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/model/jam/JsfJamModel", "getModel"));
        }
        return (JsfJamModel)ModuleServiceManager.getService((Module)module, JsfJamModel.class);
    }

    public JsfJamModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/model/jam/JsfJamModel", "<init>"));
        }
        this.myModule = module;
    }

    public List<JsfJamManagedBean> getManagedBeans(boolean showFromLibraries) {
        return this.getJamClassElements(JsfJamManagedBean.META, "javax.faces.bean.ManagedBean", showFromLibraries);
    }

    public List<JsfJamConverter> getConverters(boolean showFromLibraries) {
        return this.getJamClassElements(JsfJamConverter.META, "javax.faces.convert.FacesConverter", showFromLibraries);
    }

    public List<JsfJamComponent> getComponents(boolean showFromLibraries) {
        return this.getJamClassElements(JsfJamComponent.META, "javax.faces.component.FacesComponent", showFromLibraries);
    }

    public List<JsfJamRenderer> getRenderers(boolean showFromLibraries) {
        return this.getJamClassElements(JsfJamRenderer.META, "javax.faces.render.FacesRenderer", showFromLibraries);
    }

    public List<JsfJamValidator> getValidators(boolean showFromLibraries) {
        return this.getJamClassElements(JsfJamValidator.META, "javax.faces.validator.FacesValidator", showFromLibraries);
    }

    public List<JsfJamListenerFor> getListenerFors(boolean showFromLibraries) {
        return this.getJamClassElements(JsfJamListenerFor.META, "javax.faces.event.ListenerFor", showFromLibraries);
    }

    public List<JsfJamListenersFor> getListenersFors(boolean showFromLibraries) {
        return this.getJamClassElements(JsfJamListenersFor.META, "javax.faces.event.ListenersFor", showFromLibraries);
    }

    public <T extends JamElement> List<T> getJamClassElements(JamClassMeta<T> clazz, String anno, boolean showFromLibraries) {
        JamService service = JamService.getJamService((Project)this.myModule.getProject());
        GlobalSearchScope scope = this.getScope(showFromLibraries);
        return service.getJamClassElements(clazz, anno, scope);
    }

    private GlobalSearchScope getScope(boolean showFromLibraries) {
        return showFromLibraries ? GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.myModule) : GlobalSearchScope.moduleWithDependenciesScope((Module)this.myModule);
    }
}

