/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.impl.model.xml;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.FacesDomModelFactory;
import com.intellij.jsf.model.xml.FacesDomModelManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.converters.values.GenericDomValueConvertersRegistry;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacesDomModelManagerImpl
extends FacesDomModelManager {
    private final Map<WebFacet, FacesDomModelFactory> myFactories = new FactoryMap<WebFacet, FacesDomModelFactory>(){

        protected FacesDomModelFactory create(final WebFacet key) {
            return new FacesDomModelFactory(FacesDomModelManagerImpl.this.myProject){

                protected WebFacet getModelScope(XmlFile file) {
                    return key;
                }
            };
        }
    };
    private final Project myProject;
    private final DomManager myDomManager;
    private final GenericDomValueConvertersRegistry myValueProvidersRegistry;

    public FacesDomModelManagerImpl(Project project, DomManager domManager) {
        this.myProject = project;
        this.myDomManager = domManager;
        this.myValueProvidersRegistry = new GenericDomValueConvertersRegistry();
        this.myValueProvidersRegistry.registerDefaultConverters();
    }

    @Override
    public boolean isFacesConfig(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/impl/model/xml/FacesDomModelManagerImpl", "isFacesConfig"));
        }
        return this.myDomManager.getFileElement(file, FacesConfig.class) != null;
    }

    @Override
    @Nullable
    public FacesDomModel getFacesDomModel(@NotNull XmlFile file, @NotNull WebFacet webFacet) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/impl/model/xml/FacesDomModelManagerImpl", "getFacesDomModel"));
        }
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/jsf/impl/model/xml/FacesDomModelManagerImpl", "getFacesDomModel"));
        }
        return (FacesDomModel)this.getModelFactory(webFacet).getModelByConfigFile(file);
    }

    @Override
    @NotNull
    public List<FacesDomModel> getAllModels(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/jsf/impl/model/xml/FacesDomModelManagerImpl", "getAllModels"));
        }
        List list = this.getModelFactory(webFacet).getAllModels((UserDataHolder)webFacet);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/impl/model/xml/FacesDomModelManagerImpl", "getAllModels"));
        }
        return list;
    }

    @Override
    public FacesDomModel getCombinedModel(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/jsf/impl/model/xml/FacesDomModelManagerImpl", "getCombinedModel"));
        }
        return (FacesDomModel)this.getModelFactory(webFacet).getCombinedModel((UserDataHolder)webFacet);
    }

    @Override
    @NotNull
    public GenericDomValueConvertersRegistry getValueConvertersRegistry() {
        GenericDomValueConvertersRegistry genericDomValueConvertersRegistry = this.myValueProvidersRegistry;
        if (genericDomValueConvertersRegistry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/impl/model/xml/FacesDomModelManagerImpl", "getValueConvertersRegistry"));
        }
        return genericDomValueConvertersRegistry;
    }

    @NotNull
    public FacesDomModelFactory getModelFactory(@NotNull WebFacet webFacet) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/jsf/impl/model/xml/FacesDomModelManagerImpl", "getModelFactory"));
        }
        FacesDomModelFactory facesDomModelFactory = this.myFactories.get(webFacet);
        if (facesDomModelFactory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/impl/model/xml/FacesDomModelManagerImpl", "getModelFactory"));
        }
        return facesDomModelFactory;
    }
}

