/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.html5.tagDecorators;

import com.intellij.jsf.html5.tagDecorators.TagDecoratorHandler;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsfHtmlDecorator
implements TagDecoratorHandler {
    private Pair<String, String> myDecoratorTagName;
    private String withName;
    private Pair<String, String> withAttribute;
    private String withAttributeValue;

    private JsfHtmlDecorator(@NotNull String decoratorName) {
        if (decoratorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decoratorName", "com/intellij/jsf/html5/tagDecorators/JsfHtmlDecorator", "<init>"));
        }
        this.withName = null;
        this.withAttribute = null;
        this.withAttributeValue = null;
        this.myDecoratorTagName = Pair.create((Object)"http://xmlns.jcp.org/jsf/html", (Object)decoratorName);
    }

    public static JsfHtmlDecorator create(@NotNull String decoratorName) {
        if (decoratorName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decoratorName", "com/intellij/jsf/html5/tagDecorators/JsfHtmlDecorator", "create"));
        }
        return new JsfHtmlDecorator(decoratorName);
    }

    public JsfHtmlDecorator tag(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/jsf/html5/tagDecorators/JsfHtmlDecorator", "tag"));
        }
        this.withName = tagName;
        return this;
    }

    public JsfHtmlDecorator withAttribute(@NotNull String attName, @NotNull String attNamespace) {
        if (attName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attName", "com/intellij/jsf/html5/tagDecorators/JsfHtmlDecorator", "withAttribute"));
        }
        if (attNamespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attNamespace", "com/intellij/jsf/html5/tagDecorators/JsfHtmlDecorator", "withAttribute"));
        }
        this.withAttribute = Pair.create((Object)attName, (Object)attNamespace);
        return this;
    }

    public JsfHtmlDecorator withAttributeValue(@NotNull String attName, @NotNull String attValue) {
        if (attName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attName", "com/intellij/jsf/html5/tagDecorators/JsfHtmlDecorator", "withAttributeValue"));
        }
        if (attValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attValue", "com/intellij/jsf/html5/tagDecorators/JsfHtmlDecorator", "withAttributeValue"));
        }
        this.withAttribute = Pair.create((Object)attName, null);
        this.withAttributeValue = attValue;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public Pair<String, String> decorate(@NotNull XmlTag tag) {
        XmlAttribute attribute;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/jsf/html5/tagDecorators/JsfHtmlDecorator", "decorate"));
        }
        if (!tag.getLocalName().equals(this.withName)) return null;
        if (this.withAttribute == null) return this.myDecoratorTagName;
        String attrName = (String)this.withAttribute.first;
        String attrNamespace = (String)this.withAttribute.second;
        XmlAttribute xmlAttribute = attribute = attrNamespace == null ? tag.getAttribute(attrName) : tag.getAttribute(attrName, attrNamespace);
        if (attribute == null) return null;
        if (this.withAttributeValue == null) return this.myDecoratorTagName;
        if (!this.withAttributeValue.equals(attribute.getValue())) return null;
        return this.myDecoratorTagName;
    }
}

