/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.highlighting.jam;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jsf.highlighting.jam.BaseJsfJamInspection;
import com.intellij.jsf.resources.FacesInspectionsBundle;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JsfJamExtendsClassInconsistencyInspection
extends BaseJsfJamInspection {
    @Override
    protected void checkClass(PsiClass aClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/highlighting/jam/JsfJamExtendsClassInconsistencyInspection", "checkClass"));
        }
        JsfJamExtendsClassInconsistencyInspection.checkAnnotatedComponent(aClass, holder, module, "javax.faces.component.FacesComponent", "javax.faces.component.UIComponent");
        JsfJamExtendsClassInconsistencyInspection.checkAnnotatedComponent(aClass, holder, module, "javax.faces.convert.FacesConverter", "javax.faces.convert.Converter");
        JsfJamExtendsClassInconsistencyInspection.checkAnnotatedComponent(aClass, holder, module, "javax.faces.render.FacesRenderer", "javax.faces.render.Renderer");
        JsfJamExtendsClassInconsistencyInspection.checkAnnotatedComponent(aClass, holder, module, "javax.faces.validator.FacesValidator", "javax.faces.validator.Validator");
    }

    private static void checkAnnotatedComponent(PsiClass aClass, ProblemsHolder holder, Module module, String annotation, String baseClassFQN) {
        PsiAnnotation psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{annotation});
        if (psiAnnotation != null && JsfJamExtendsClassInconsistencyInspection.isNonExtends(aClass, baseClassFQN, module)) {
            holder.registerProblem((PsiElement)psiAnnotation, FacesInspectionsBundle.message("JsfJamExtendsClassInconsistencyInspection.interface.must.be.implemented", baseClassFQN), new LocalQuickFix[0]);
        }
    }

    private static boolean isNonExtends(PsiClass psiClass, String baseClass, Module module) {
        PsiClass basePsiClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(baseClass, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        return basePsiClass != null && !psiClass.isInheritor(basePsiClass, true);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = FacesInspectionsBundle.message("inspection.name.extends.inconsistency.errors", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/highlighting/jam/JsfJamExtendsClassInconsistencyInspection", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("JsfJamExtendsClassInconsistencyInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/highlighting/jam/JsfJamExtendsClassInconsistencyInspection", "getShortName"));
        }
        return "JsfJamExtendsClassInconsistencyInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/highlighting/jam/JsfJamExtendsClassInconsistencyInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }
}

