/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.highlighting;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.javaee.facet.JavaeeFacetUtil;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.highlighting.jam.JsfJamExtendsClassInconsistencyInspection;
import com.intellij.jsf.highlighting.xml.JsfDomModelInspection;
import com.intellij.jsf.highlighting.xml.JsfManagedBeansInconsistencyInspection;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.jsf.utils.FacesConfigUtils;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FacesValidator
extends InspectionValidator {
    public FacesValidator() {
        super("Faces Validator", FacesBundle.message("model.inspection.validator.progress.text", new Object[0]));
    }

    @NotNull
    public Class<? extends LocalInspectionTool>[] getInspectionToolClasses(CompileContext context) {
        Class[] classArray = new Class[]{JsfManagedBeansInconsistencyInspection.class, JsfDomModelInspection.class, JsfJamExtendsClassInconsistencyInspection.class};
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/highlighting/FacesValidator", "getInspectionToolClasses"));
        }
        return classArray;
    }

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/jsf/highlighting/FacesValidator", "isAvailableOnScope"));
        }
        return FacesValidator.getWebFacets(scope).size() > 0;
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        ArrayList<VirtualFile> list = new ArrayList<VirtualFile>();
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
                for (PsiFile psiFile : FacesConfigUtils.getConfigurationFiles(webFacet)) {
                    ContainerUtil.addIfNotNull(list, (Object)psiFile.getVirtualFile());
                }
            }
        }
        InspectionValidatorUtil.expandCompileScopeIfNeeded(list, (CompileContext)context);
        return list;
    }

    @NotNull
    public Collection<XmlFile> getDependencies(PsiFile psiFile) {
        WebFacet webFacet = WebUtil.getWebFacet((VirtualFile)psiFile.getVirtualFile(), (Project)psiFile.getProject());
        if (webFacet == null) {
            List<XmlFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/highlighting/FacesValidator", "getDependencies"));
            }
            return list;
        }
        Set<XmlFile> facesConfigXmls = FacesConfigUtils.getConfigurationFiles(webFacet);
        facesConfigXmls.remove(psiFile);
        Set<XmlFile> set = facesConfigXmls;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/highlighting/FacesValidator", "getDependencies"));
        }
        return set;
    }

    private static Collection<WebFacet> getWebFacets(CompileScope compileScope) {
        Module[] modules = compileScope.getAffectedModules();
        return JavaeeFacetUtil.getInstance().getJavaeeFacets(WebFacet.ID, modules);
    }
}

