/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.facet;

import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.javaee.model.xml.web.Servlet;
import com.intellij.javaee.model.xml.web.ServletMapping;
import com.intellij.javaee.model.xml.web.WebApp;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsf.resources.FacesBundle;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.deployment.DeploymentUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.descriptors.ConfigFile;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddFacesSupportUtil {
    @NonNls
    private static final String FACES_CONFIG_DEFAULT_RELATIVE_PATH = "/WEB-INF/faces-config.xml";
    @NonNls
    private static final String FACES_SERVLET = "Faces Servlet";
    @NonNls
    private static final String[] FACES_URL_PATTERNS = new String[]{"*.xhtml"};
    @NonNls
    private static final String JAVAX_FACES_WEBAPP_FACES_SERVLET = "javax.faces.webapp.FacesServlet";

    private AddFacesSupportUtil() {
    }

    @Nullable
    public static VirtualFile createFacesConfig(WebFacet webFacet, @Nullable String version, @NotNull @NonNls String configFilePath) throws IOException {
        VirtualFile file;
        if (configFilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFilePath", "com/intellij/jsf/facet/AddFacesSupportUtil", "createFacesConfig"));
        }
        File configFile = new File(FileUtil.toSystemDependentName((String)configFilePath));
        if (!configFile.exists()) {
            final String text = JsfCommonUtils.getFacesConfigTemplateText(version);
            FileUtil.createIfDoesntExist((File)configFile);
            file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(configFile);
            new WriteAction(){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/jsf/facet/AddFacesSupportUtil$1", "run"));
                    }
                    VfsUtil.saveText((VirtualFile)file, (String)text);
                }
            }.execute().throwException();
        } else {
            file = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(configFile);
        }
        AddFacesSupportUtil.write2WebXml(webFacet, file);
        return file;
    }

    public static void write2WebXml(@NotNull WebFacet webFacet, @NotNull VirtualFile file) {
        if (webFacet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "webFacet", "com/intellij/jsf/facet/AddFacesSupportUtil", "write2WebXml"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/facet/AddFacesSupportUtil", "write2WebXml"));
        }
        WebRoot webRoot = WebUtil.findParentWebRoot((VirtualFile)file, (List)webFacet.getWebRoots());
        if (webRoot != null) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)webRoot.getFile(), (char)'/');
            WebApp root = webFacet.getRoot();
            if (relativePath != null && root != null) {
                AddFacesSupportUtil.patchWebXml(webFacet.getModule().getProject(), webRoot, relativePath, root);
            }
        }
    }

    private static void patchWebXml(Project project, WebRoot webRoot, String relativePath, WebApp root) {
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            PsiFile containingFile;
            String uri = webRoot.getURI();
            String path = DeploymentUtil.appendToPath((String)uri, (String)relativePath);
            if (!FACES_CONFIG_DEFAULT_RELATIVE_PATH.equals(path)) {
                ParamValue param = AddFacesSupportUtil.findOrCreateContextParam(root);
                String value = (String)param.getParamValue().getValue();
                if (StringUtil.isEmpty((String)value)) {
                    param.getParamValue().setValue((Object)path);
                } else if (!AddFacesSupportUtil.containsPath(value, path)) {
                    param.getParamValue().setValue((Object)(value + "," + path));
                }
            }
            if ((containingFile = root.getContainingFile()) != null && ReadonlyStatusHandler.ensureFilesWritable((Project)containingFile.getProject(), (VirtualFile[])new VirtualFile[]{containingFile.getVirtualFile()})) {
                AddFacesSupportUtil.addFacesServlet(root);
                AddFacesSupportUtil.addFacesMapping(root);
            }
        });
    }

    private static void addFacesMapping(WebApp root) {
        for (ServletMapping mapping : root.getServletMappings()) {
            if (!FACES_SERVLET.equals(mapping.getServletName().getStringValue())) continue;
            return;
        }
        for (String urlPattern : FACES_URL_PATTERNS) {
            ServletMapping mapping = root.addServletMapping();
            mapping.getServletName().setStringValue(FACES_SERVLET);
            mapping.addUrlPattern().setValue((Object)urlPattern);
        }
    }

    private static void addFacesServlet(WebApp root) {
        List servlets = root.getServlets();
        for (Servlet servlet : servlets) {
            if (!FACES_SERVLET.equals(servlet.getServletName().getValue())) continue;
            return;
        }
        Servlet servlet = root.addServlet();
        servlet.getServletName().setValue((Object)FACES_SERVLET);
        servlet.getServletClass().setStringValue(JAVAX_FACES_WEBAPP_FACES_SERVLET);
        servlet.getLoadOnStartup().setValue((Object)1);
    }

    private static boolean containsPath(String value, String path) {
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            if (!path.equals(token)) continue;
            return true;
        }
        return false;
    }

    private static ParamValue findOrCreateContextParam(WebApp root) {
        List list = root.getContextParams();
        for (ParamValue paramValue : list) {
            if (!"javax.faces.CONFIG_FILES".equals(paramValue.getParamName().getValue())) continue;
            return paramValue;
        }
        ParamValue paramValue = root.addContextParam();
        paramValue.getParamName().setValue((Object)"javax.faces.CONFIG_FILES");
        return paramValue;
    }

    @Nullable
    public static VirtualFile getDefaultDirectoryForFacesConfig(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/facet/AddFacesSupportUtil", "getDefaultDirectoryForFacesConfig"));
        }
        for (WebFacet webFacet : WebFacet.getInstances((Module)module)) {
            List webRoots = webFacet.getWebRoots();
            for (WebRoot webRoot : webRoots) {
                if (!webRoot.getURI().equals("/WEB-INF")) continue;
                return webRoot.getFile();
            }
            if (webRoots.isEmpty()) continue;
            return ((WebRoot)webRoots.get(0)).getFile();
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (contentRoots.length > 0) {
            return contentRoots[0];
        }
        return module.getModuleFile().getParent();
    }

    public static void createFacesConfigInWriteCommandAction(final WebFacet webFacet, final @Nullable String version, final String configFilePath) {
        final Project project = webFacet.getModule().getProject();
        new WriteCommandAction.Simple(project, AddFacesSupportUtil.getWebXmlFile(webFacet)){

            protected void run() {
                try {
                    AddFacesSupportUtil.createFacesConfig(webFacet, version, configFilePath);
                }
                catch (IOException e) {
                    ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)FacesBundle.message("error.cannot.create.faces.config.title", new Object[0])));
                }
            }
        }.execute();
    }

    private static PsiFile[] getWebXmlFile(WebFacet webFacet) {
        PsiFile psiFile;
        ConfigFile deploymentDescriptor;
        if (webFacet != null && (deploymentDescriptor = webFacet.getWebXmlDescriptor()) != null && (psiFile = deploymentDescriptor.getPsiFile()) != null) {
            return new PsiFile[]{psiFile};
        }
        return PsiFile.EMPTY_ARRAY;
    }
}

