/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.facelets.lang;

import com.intellij.ide.highlighter.JspxFileType;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.jsf.facelets.FaceletsManager;
import com.intellij.jsf.facelets.lang.FaceletsLanguage;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FaceletsLanguageProvider
extends LanguageSubstitutor {
    @Nullable
    public Language getLanguage(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsf/facelets/lang/FaceletsLanguageProvider", "getLanguage"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jsf/facelets/lang/FaceletsLanguageProvider", "getLanguage"));
        }
        if (project.isDefault() || file instanceof VirtualFileWindow) {
            return null;
        }
        FileType fileType = file.getFileType();
        if ((fileType == XHtmlFileType.INSTANCE || fileType == JspxFileType.INSTANCE) && FaceletsManager.isFaceletsEnabled(project, file)) {
            return FaceletsLanguage.INSTANCE;
        }
        return null;
    }
}

