/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.el;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.source.jsp.el.ELLanguage;
import com.intellij.psi.impl.source.jsp.el.ELUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.hash.HashSet;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AnnotatedManagedBeanELClassInjector
implements MultiHostInjector {
    private static Set<String> myAnnotations = new HashSet();

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement host) {
        Module module;
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/jsf/el/AnnotatedManagedBeanELClassInjector", "getLanguagesToInject"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/jsf/el/AnnotatedManagedBeanELClassInjector", "getLanguagesToInject"));
        }
        if (!host.textContains('#')) {
            return;
        }
        PsiElement originalElement = CompletionUtil.getOriginalElement((PsiElement)host);
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)originalElement, PsiClass.class);
        if (psiClass != null && (module = ModuleUtil.findModuleForPsiElement((PsiElement)psiClass)) != null && JsfCommonUtils.isJsfSupported(module) && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, myAnnotations)) {
            for (TextRange textRange : ELUtil.getELTextRanges((PsiElement)host, (String)"#{", (String)"}")) {
                registrar.startInjecting(ELLanguage.INSTANCE).addPlace(null, null, (PsiLanguageInjectionHost)host, textRange).doneInjecting();
            }
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class> list = Arrays.asList(PsiLiteralExpression.class);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/el/AnnotatedManagedBeanELClassInjector", "elementsToInjectIn"));
        }
        return list;
    }

    static {
        myAnnotations.add("javax.faces.bean.ManagedBean");
        myAnnotations.add("javax.faces.bean.ManagedProperty");
    }
}

