/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.jsf.composite.CompositeComponentQuickFixProvider;
import com.intellij.jsf.composite.CompositeNamespaceDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.XmlUndefinedElementFixProvider;
import org.jetbrains.annotations.NotNull;

public class CompositeNamespaceUndefinedElementFixProvider
extends XmlUndefinedElementFixProvider {
    public IntentionAction[] createFixes(@NotNull XmlAttribute attribute) {
        XmlNSDescriptor nsDescriptor;
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/jsf/composite/CompositeNamespaceUndefinedElementFixProvider", "createFixes"));
        }
        XmlTag tag = attribute.getParent();
        String namespace = attribute.getNamespace();
        if (StringUtil.isEmptyOrSpaces((String)namespace)) {
            namespace = tag.getNamespace();
        }
        if ((nsDescriptor = tag.getNSDescriptor(namespace, true)) instanceof CompositeNamespaceDescriptor) {
            String resourcesPath = ((CompositeNamespaceDescriptor)nsDescriptor).getResourcesPath();
            IntentionAction fix = CompositeComponentQuickFixProvider.createCompositeComponentAttributeQuickFix(attribute, resourcesPath);
            if (fix != null) {
                return new IntentionAction[]{fix};
            }
            return IntentionAction.EMPTY_ARRAY;
        }
        return null;
    }

    public LocalQuickFix[] createFixes(@NotNull XmlTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tag", "com/intellij/jsf/composite/CompositeNamespaceUndefinedElementFixProvider", "createFixes"));
        }
        XmlNSDescriptor descriptor = tag.getNSDescriptor(tag.getNamespace(), true);
        if (descriptor instanceof CompositeNamespaceDescriptor) {
            String resourcesPath = ((CompositeNamespaceDescriptor)descriptor).getResourcesPath();
            LocalQuickFix fix = CompositeComponentQuickFixProvider.createCompositeComponentFileQuickFix(tag, resourcesPath);
            if (fix != null) {
                return new LocalQuickFix[]{fix};
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return null;
    }
}

