/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.actions;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.jsf.UserDefinedFacesConfigs;
import com.intellij.jsf.utils.FacesConfigUtils;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import org.jetbrains.annotations.Nullable;

public class UserDefinedFacesConfigAction
extends ToggleAction {
    public boolean isSelected(AnActionEvent e) {
        Module module;
        XmlFile xmlFile;
        boolean enabled = false;
        boolean selected = false;
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        Project project = e.getProject();
        if (project != null && file instanceof XmlFile && FacesConfigUtils.isFacesConfig(xmlFile = (XmlFile)file) && (module = UserDefinedFacesConfigAction.getModule(file)) != null) {
            enabled = true;
            selected = UserDefinedFacesConfigs.getInstance(module).getFiles().contains(file.getVirtualFile());
        }
        e.getPresentation().setVisible(enabled);
        e.getPresentation().setEnabled(enabled);
        return selected;
    }

    @Nullable
    private static Module getModule(@Nullable PsiFile file) {
        if (file == null) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        return virtualFile == null ? null : ProjectRootManagerEx.getInstanceEx((Project)file.getProject()).getFileIndex().getModuleForFile(virtualFile);
    }

    public void setSelected(AnActionEvent e, boolean state) {
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(e.getDataContext());
        Module module = UserDefinedFacesConfigAction.getModule(file);
        if (module != null && file instanceof XmlFile) {
            if (state) {
                UserDefinedFacesConfigs.getInstance(module).addFile(file.getVirtualFile());
            } else {
                UserDefinedFacesConfigs.getInstance(module).removeFile(file.getVirtualFile());
            }
            UserDefinedFacesConfigAction.updateIde(e, (XmlFile)file);
        }
    }

    private static void updateIde(AnActionEvent e, XmlFile xmlFile) {
        ProjectView.getInstance((Project)xmlFile.getProject()).refresh();
        FileEditorManager.getInstance((Project)xmlFile.getProject()).closeFile(xmlFile.getVirtualFile());
        FileEditorManager.getInstance((Project)xmlFile.getProject()).openFile(xmlFile.getVirtualFile(), false);
    }
}

