/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf;

import com.intellij.javaee.UriUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

public class UserDefinedFacesConfigs
implements JDOMExternalizable {
    public JDOMExternalizableStringList USER_DEFINED_CONFIGS = new JDOMExternalizableStringList();
    private final Project myProject;

    public UserDefinedFacesConfigs(Module module) {
        this.myProject = module.getProject();
    }

    public static UserDefinedFacesConfigs getInstance(Module module) {
        return (UserDefinedFacesConfigs)ModuleServiceManager.getService((Module)module, UserDefinedFacesConfigs.class);
    }

    public void addFile(VirtualFile file) {
        this.USER_DEFINED_CONFIGS.add((Object)this.getPath(file));
    }

    public void removeFile(VirtualFile file) {
        this.USER_DEFINED_CONFIGS.remove((Object)this.getPath(file));
    }

    private String getPath(VirtualFile file) {
        String relativePath;
        if (this.myProject.getBaseDir() != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)this.myProject.getBaseDir(), (char)'/')) != null) {
            return relativePath;
        }
        return file.getUrl();
    }

    public List<VirtualFile> getFiles() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (String path : this.USER_DEFINED_CONFIGS) {
            VirtualFile file = this.findFile(path);
            if (file == null) continue;
            files.add(file);
        }
        return files;
    }

    @Nullable
    private VirtualFile findFile(String path) {
        VirtualFile virtualFile;
        if (this.myProject.getBaseDir() != null && (virtualFile = UriUtil.findRelativeFile((String)path, (VirtualFile)this.myProject.getBaseDir())) != null) {
            return virtualFile;
        }
        return VirtualFileManager.getInstance().findFileByUrl(path);
    }

    private void removeUnusedFiles() {
        for (int i = this.USER_DEFINED_CONFIGS.size() - 1; i >= 0; --i) {
            String path = (String)this.USER_DEFINED_CONFIGS.get(i);
            VirtualFile file = this.findFile(path);
            if (file != null) continue;
            this.USER_DEFINED_CONFIGS.remove(i);
        }
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        this.removeUnusedFiles();
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (this.USER_DEFINED_CONFIGS.isEmpty()) {
            throw new WriteExternalException();
        }
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }
}

