/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.indexer.impl.util;

import java.util.List;
import java.util.Map;
import org.osgi.service.indexer.impl.util.Create;
import org.osgi.service.indexer.impl.util.QuotedTokenizer;
import org.osgi.service.indexer.impl.util.Reporter;

public class OSGiHeader {
    private static final char DUPLICATE_MARKER = '~';

    public static Map<String, Map<String, String>> parseHeader(String value) {
        return OSGiHeader.parseHeader(value, null);
    }

    public static Map<String, Map<String, String>> parseHeader(String value, Reporter logger) {
        if (value == null || value.trim().length() == 0) {
            return Create.map();
        }
        Map<String, Map<String, String>> result = Create.map();
        QuotedTokenizer qt = new QuotedTokenizer(value, ";=,");
        char del = '\u0000';
        do {
            boolean hadAttribute = false;
            Map<String, String> clause = Create.map();
            List<String> aliases = Create.list();
            String name = qt.nextToken(",;");
            del = qt.getSeparator();
            if (name == null || name.length() == 0) {
                if (logger != null && logger.isPedantic()) {
                    logger.warning("Empty clause, usually caused by repeating a comma without any name field or by having spaces after the backslash of a property file: " + value, new Object[0]);
                }
                if (name != null) continue;
                break;
            }
            name = name.trim();
            aliases.add(name);
            while (del == ';') {
                String adname = qt.nextToken();
                del = qt.getSeparator();
                if (del != '=') {
                    if (hadAttribute && logger != null) {
                        logger.error("Header contains name field after attribute or directive: " + adname + " from " + value + ". Name fields must be consecutive, separated by a ';' like a;b;c;x=3;y=4", new Object[0]);
                    }
                    if (adname == null || adname.length() <= 0) continue;
                    aliases.add(adname.trim());
                    continue;
                }
                String advalue = qt.nextToken();
                if (advalue == null) {
                    if (logger != null) {
                        logger.error("No value after '=' sign for attribute " + adname, new Object[0]);
                    }
                    advalue = "";
                }
                while (clause.containsKey(adname.trim())) {
                    adname = adname.trim() + '~';
                }
                clause.put(adname.trim(), advalue.trim());
                del = qt.getSeparator();
                hadAttribute = true;
            }
            for (String clauseName : aliases) {
                if (result.containsKey(clauseName)) {
                    if (logger != null && logger.isPedantic()) {
                        logger.warning("Duplicate name " + clauseName + " used in header: '" + clauseName + "'. Duplicate names are specially marked in Bnd with a ~ at the end (which is stripped at printing time).", new Object[0]);
                    }
                    while (result.containsKey(clauseName)) {
                        clauseName = clauseName + '~';
                    }
                }
                result.put(clauseName, clause);
            }
        } while (del == ',');
        return result;
    }

    public static Map<String, String> parseProperties(String input) {
        return OSGiHeader.parseProperties(input, null);
    }

    public static Map<String, String> parseProperties(String input, Reporter logger) {
        if (input == null || input.trim().length() == 0) {
            return Create.map();
        }
        Map<String, String> result = Create.map();
        QuotedTokenizer qt = new QuotedTokenizer(input, "=,");
        int del = 44;
        while (del == 44) {
            String key = qt.nextToken(",=");
            String value = "";
            del = qt.getSeparator();
            if (del == 61) {
                value = qt.nextToken(",=");
                del = qt.getSeparator();
            }
            result.put(key, value);
        }
        if (del != 0) {
            if (logger == null) {
                throw new IllegalArgumentException("Invalid syntax for properties: " + input);
            }
            logger.error("Invalid syntax for properties: " + input, new Object[0]);
        }
        return result;
    }

    public static String removeDuplicateMarker(String key) {
        int i;
        for (i = key.length() - 1; i >= 0 && key.charAt(i) == '~'; --i) {
        }
        return key.substring(0, i + 1);
    }
}

