/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.indexer.impl;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.Version;
import org.osgi.service.indexer.Builder;
import org.osgi.service.indexer.Capability;
import org.osgi.service.indexer.Requirement;
import org.osgi.service.indexer.Resource;
import org.osgi.service.indexer.ResourceAnalyzer;
import org.osgi.service.indexer.impl.Util;
import org.osgi.service.indexer.impl.types.ScalarType;
import org.osgi.service.indexer.impl.types.TypedValue;
import org.osgi.service.indexer.impl.types.VersionKey;
import org.osgi.service.indexer.impl.types.VersionRange;
import org.osgi.service.log.LogService;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SCRAnalyzer
implements ResourceAnalyzer {
    static final Pattern URI_VERSION_P = Pattern.compile("/scr/v(\\d+\\.\\d+\\.\\d+)$");
    public static final String NS_1_0 = "http://www.osgi.org/xmlns/scr/v1.0.0";
    public static final String NS_1_1 = "http://www.osgi.org/xmlns/scr/v1.1.0";
    public static final String NS_1_2 = "http://www.osgi.org/xmlns/scr/v1.2.0";
    public static final String NS_1_2_1 = "http://www.osgi.org/xmlns/scr/v1.2.1";
    public static final String NS_1_3 = "http://www.osgi.org/xmlns/scr/v1.3.0";
    public static final String ELEMENT_COMPONENT = "component";
    public static final String ELEMENT_SERVICE = "service";
    public static final String ELEMENT_PROVIDE = "provide";
    public static final String ELEMENT_REFERENCE = "reference";
    public static final String ELEMENT_PROPERTY = "property";
    public static final String ATTRIB_INTERFACE = "interface";
    public static final String ATTRIB_CARDINALITY = "cardinality";
    public static final String ATTRIB_NAME = "name";
    public static final String ATTRIB_TYPE = "type";
    public static final String ATTRIB_VALUE = "value";
    public static final String ATTRIB_TARGET = "target";
    private LogService log;

    public SCRAnalyzer(LogService log) {
        this.log = log;
    }

    @Override
    public void analyzeResource(Resource resource, List<Capability> caps, List<Requirement> reqs) throws Exception {
        String header = null;
        Manifest manifest = resource.getManifest();
        if (manifest != null) {
            header = manifest.getMainAttributes().getValue("Service-Component");
        }
        if (header == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(header, ",");
        Version highest = null;
        while (tokenizer.hasMoreTokens()) {
            String pattern = tokenizer.nextToken().trim();
            List<String> paths = Util.findMatchingPaths(resource, pattern);
            if (paths == null) continue;
            for (String path : paths) {
                Version version = this.processScrXml(resource, path, caps, reqs);
                if (version == null || highest != null && version.compareTo(highest) <= 0) continue;
                highest = version;
            }
        }
        if (highest != null) {
            Version lower = new Version(highest.getMajor(), highest.getMinor(), 0);
            Version upper = new Version(highest.getMajor() + 1, 0, 0);
            Requirement requirement = SCRAnalyzer.createRequirement(new VersionRange(true, lower, upper, false));
            reqs.add(requirement);
        }
    }

    private Version processScrXml(Resource resource, String path, List<Capability> caps, List<Requirement> reqs) throws IOException {
        Resource childResource = resource.getChild(path);
        if (childResource == null) {
            if (this.log != null) {
                this.log.log(2, MessageFormat.format("Cannot analyse SCR requirement version: resource {0} does not contain path {1} referred from Service-Component header.", resource.getLocation(), path));
            }
            return null;
        }
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        try {
            SAXParser parser = spf.newSAXParser();
            SCRContentHandler handler = new SCRContentHandler(caps, reqs);
            parser.parse(childResource.getStream(), (DefaultHandler)handler);
            return handler.highest;
        }
        catch (Exception e) {
            if (this.log != null) {
                this.log.log(1, MessageFormat.format("Processing error: failed to parse child resource {0} in resource {1}.", path, resource.getLocation()), e);
            }
            return null;
        }
    }

    private static Requirement createRequirement(VersionRange range) {
        Builder builder = new Builder().setNamespace("osgi.extender");
        StringBuilder filter = new StringBuilder();
        filter.append('(').append("osgi.extender").append('=').append("osgi.component").append(')');
        filter.insert(0, "(&");
        Util.addVersionFilter(filter, range, VersionKey.PackageVersion);
        filter.append(')');
        builder.addDirective("filter", filter.toString()).addDirective("effective", "active");
        Requirement requirement = builder.buildRequirement();
        return requirement;
    }

    private static class SCRContentHandler
    extends DefaultHandler {
        private List<Capability> caps;
        private List<Requirement> reqs;
        Version highest = null;
        private List<String> provides = null;
        private List<Requirement> references = null;
        private Map<String, Object> properties = null;
        private String currentPropertyName = null;
        private ScalarType currentPropertyType = null;
        private String currentPropertyValue = null;
        private StringBuilder currentPropertyText = null;

        public SCRContentHandler(List<Capability> caps, List<Requirement> reqs) {
            this.caps = caps;
            this.reqs = reqs;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attribs) throws SAXException {
            super.startElement(uri, localName, qName, attribs);
            String localNameLowerCase = localName.toLowerCase();
            if (SCRAnalyzer.ELEMENT_COMPONENT.equals(localNameLowerCase)) {
                this.provides = new LinkedList<String>();
                this.properties = new LinkedHashMap<String, Object>();
                this.references = new LinkedList<Requirement>();
                if (uri == null || "".equals(uri)) {
                    this.setVersion(new Version(1, 0, 0));
                    return;
                } else {
                    Matcher m = URI_VERSION_P.matcher(uri);
                    if (!m.find()) throw new SAXException("Unknown namespace " + uri);
                    String v = m.group(1);
                    this.setVersion(new Version(v));
                }
                return;
            } else if (SCRAnalyzer.ELEMENT_PROVIDE.equals(localNameLowerCase)) {
                String objectClass = attribs.getValue(SCRAnalyzer.ATTRIB_INTERFACE);
                this.provides.add(objectClass);
                return;
            } else if (SCRAnalyzer.ELEMENT_PROPERTY.equals(localNameLowerCase)) {
                this.currentPropertyName = attribs.getValue(SCRAnalyzer.ATTRIB_NAME);
                if (this.currentPropertyName == null) {
                    throw new SAXException("Missing required attribute 'name'.");
                }
                this.currentPropertyType = SCRContentHandler.typeOf(attribs.getValue(SCRAnalyzer.ATTRIB_TYPE));
                String value = attribs.getValue(SCRAnalyzer.ATTRIB_VALUE);
                if (value != null) {
                    this.currentPropertyValue = value;
                    return;
                } else {
                    this.currentPropertyText = new StringBuilder();
                }
                return;
            } else {
                if (!SCRAnalyzer.ELEMENT_REFERENCE.equals(localNameLowerCase)) return;
                this.references.add(SCRContentHandler.createServiceRequirement(attribs));
            }
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            if (this.currentPropertyName != null && this.currentPropertyText != null) {
                this.currentPropertyText.append(chars, start, length);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String localNameLowerCase = localName.toLowerCase();
            if (SCRAnalyzer.ELEMENT_PROPERTY.equals(localNameLowerCase)) {
                if (this.currentPropertyValue != null) {
                    Object value = SCRContentHandler.readTyped(this.currentPropertyType, this.currentPropertyValue);
                    this.properties.put(this.currentPropertyName, new TypedValue(this.currentPropertyType, value));
                } else if (this.currentPropertyText != null) {
                    String[] lines = this.currentPropertyText.toString().split("\n");
                    ArrayList<Object> values = new ArrayList<Object>(lines.length);
                    for (int i = 0; i < lines.length; ++i) {
                        String line = lines[i].trim();
                        if (line.length() <= 0) continue;
                        Object value = SCRContentHandler.readTyped(this.currentPropertyType, line);
                        values.add(value);
                    }
                    this.properties.put(this.currentPropertyName, new TypedValue(this.currentPropertyType, values));
                }
                this.currentPropertyName = null;
                this.currentPropertyType = null;
                this.currentPropertyValue = null;
                this.currentPropertyText = null;
            }
            if (SCRAnalyzer.ELEMENT_COMPONENT.equals(localNameLowerCase)) {
                if (this.provides != null && !this.provides.isEmpty()) {
                    Builder builder = new Builder().setNamespace("osgi.service");
                    builder.addAttribute("objectClass", this.provides);
                    for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                        builder.addAttribute(entry.getKey(), entry.getValue());
                    }
                    StringBuilder uses = new StringBuilder();
                    boolean first = true;
                    for (String objectClass : this.provides) {
                        if (!first) {
                            uses.append(',');
                        }
                        first = false;
                        int dotindex = objectClass.lastIndexOf(46);
                        if (dotindex < 0) {
                            throw new SAXException("Service interface in default package.");
                        }
                        String pkgName = objectClass.substring(0, dotindex);
                        uses.append(pkgName);
                    }
                    builder.addDirective("uses", uses.toString());
                    this.caps.add(builder.buildCapability());
                }
                if (this.references != null && !this.references.isEmpty()) {
                    this.reqs.addAll(this.references);
                }
            }
            super.endElement(uri, localName, qName);
        }

        private void setVersion(Version version) {
            if (this.highest == null || version.compareTo(this.highest) > 0) {
                this.highest = version;
            }
        }

        private static Requirement createServiceRequirement(Attributes attribs) throws SAXException {
            String interfaceClass = attribs.getValue(SCRAnalyzer.ATTRIB_INTERFACE);
            if (interfaceClass == null || interfaceClass.length() == 0) {
                throw new SAXException("Missing required interface attribute");
            }
            Builder builder = new Builder().setNamespace("osgi.service");
            String filter = String.format("(%s=%s)", "objectClass", interfaceClass);
            builder.addDirective("filter", filter);
            String cardinality = attribs.getValue(SCRAnalyzer.ATTRIB_CARDINALITY);
            if (cardinality != null && (cardinality = cardinality.trim().toLowerCase()).length() > 0) {
                if ('0' == cardinality.charAt(0)) {
                    builder.addDirective("resolution", "optional");
                }
                if ('n' == cardinality.charAt(cardinality.length() - 1)) {
                    builder.addDirective(SCRAnalyzer.ATTRIB_CARDINALITY, "multiple");
                }
            }
            builder.addDirective("effective", "active");
            return builder.buildRequirement();
        }

        private static ScalarType typeOf(String name) {
            if (name == null) {
                return ScalarType.String;
            }
            if (Long.class.getSimpleName().equals(name) || Integer.class.getSimpleName().equals(name) || Short.class.getSimpleName().equals(name) || Byte.class.getSimpleName().equals(name)) {
                return ScalarType.Long;
            }
            if (Float.class.getSimpleName().equals(name) || Double.class.getSimpleName().equals(name)) {
                return ScalarType.Double;
            }
            return ScalarType.String;
        }

        private static Object readTyped(ScalarType type, String string) {
            switch (type) {
                case Long: {
                    return Long.parseLong(string);
                }
                case Double: {
                    return Double.parseDouble(string);
                }
            }
            return string;
        }
    }
}

