/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.indexer.impl;

import java.util.List;
import org.osgi.framework.Version;
import org.osgi.service.indexer.Builder;
import org.osgi.service.indexer.Capability;
import org.osgi.service.indexer.Requirement;
import org.osgi.service.indexer.Resource;
import org.osgi.service.indexer.ResourceAnalyzer;
import org.osgi.service.log.LogService;

public class OSGiFrameworkAnalyzer
implements ResourceAnalyzer {
    private static final String SERVICE_FRAMEWORK_FACTORY = "META-INF/services/org.osgi.framework.launch.FrameworkFactory";
    private static final String FRAMEWORK_PACKAGE = "org.osgi.framework";
    private final LogService log;

    public OSGiFrameworkAnalyzer(LogService log) {
        this.log = log;
    }

    @Override
    public void analyzeResource(Resource resource, List<Capability> caps, List<Requirement> reqs) throws Exception {
        Resource fwkFactorySvc = resource.getChild(SERVICE_FRAMEWORK_FACTORY);
        if (fwkFactorySvc != null) {
            Builder builder = new Builder().setNamespace("osgi.contract").addAttribute("osgi.contract", "OSGiFramework");
            Version specVersion = null;
            StringBuilder uses = new StringBuilder();
            boolean firstPkg = true;
            for (Capability cap : caps) {
                if (!"osgi.wiring.package".equals(cap.getNamespace())) continue;
                if (!firstPkg) {
                    uses.append(',');
                }
                String pkgName = (String)cap.getAttributes().get("osgi.wiring.package");
                uses.append(pkgName);
                firstPkg = false;
                if (!FRAMEWORK_PACKAGE.equals(pkgName)) continue;
                Version frameworkPkgVersion = (Version)cap.getAttributes().get("version");
                specVersion = this.mapFrameworkPackageVersion(frameworkPkgVersion);
            }
            if (specVersion != null) {
                builder.addAttribute("version", specVersion);
            }
            builder.addDirective("uses", uses.toString());
            caps.add(builder.buildCapability());
        }
    }

    private Version mapFrameworkPackageVersion(Version pv) {
        Version version;
        if (pv.getMajor() != 1) {
            return null;
        }
        switch (pv.getMinor()) {
            case 7: {
                version = new Version(5, 0, 0);
                break;
            }
            case 6: {
                version = new Version(4, 3, 0);
                break;
            }
            case 5: {
                version = new Version(4, 2, 0);
                break;
            }
            case 4: {
                version = new Version(4, 1, 0);
                break;
            }
            case 3: {
                version = new Version(4, 0, 0);
                break;
            }
            case 2: {
                version = new Version(3, 0, 0);
                break;
            }
            case 1: {
                version = new Version(2, 0, 0);
                break;
            }
            case 0: {
                version = new Version(1, 0, 0);
                break;
            }
            default: {
                version = null;
            }
        }
        return version;
    }
}

