/*
 * Decompiled with CFR 0.152.
 */
package aQute.struct;

import aQute.struct.struct;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.Map;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
public @interface Define {
    public String description() default "";

    public boolean optional() default false;

    public boolean id() default false;

    public String pattern() default "";

    public long min() default -9223372036854775808L;

    public long max() default 0x7FFFFFFFFFFFFFFFL;

    public String label() default "";

    public static class FieldValidator
    extends struct {
        public String label;
        public String description;
        public boolean optional = false;
        public boolean id = false;
        public String pattern;
        public long min;
        public long max;
    }

    public static class TypeValidator
    extends struct {
        public String fqn;
        public Map<String, FieldValidator> validators = TypeValidator.map();

        public static TypeValidator getValidator(Class<? extends struct> type) {
            TypeValidator tv = new TypeValidator();
            tv.fqn = type.getSimpleName();
            Field[] fieldArray = struct.getCache(type).fs;
            int n = struct.getCache(type).fs.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (!f.getName().equals("__extra")) {
                    FieldValidator v = new FieldValidator();
                    tv.validators.put(f.getName(), v);
                    Define define = f.getAnnotation(Define.class);
                    if (define != null) {
                        v.label = TypeValidator.emptyIsNull(define.label());
                        v.description = TypeValidator.emptyIsNull(define.description());
                        v.optional = define.optional();
                        v.id = define.id();
                        v.pattern = TypeValidator.emptyIsNull(define.pattern());
                        v.min = define.min();
                        v.max = define.max();
                    } else {
                        v.label = TypeValidator.toLabel(f.getName());
                        v.id = f.getName().equals("_id");
                    }
                }
                ++n2;
            }
            return tv;
        }

        private static String toLabel(String name) {
            StringBuilder sb = new StringBuilder(Character.toUpperCase(name.charAt(0)));
            int i = 1;
            while (i < name.length() - 1) {
                char c = name.charAt(i);
                char f = name.charAt(i + 1);
                if (Character.isUpperCase(c) && Character.isLowerCase(f)) {
                    sb.append(' ');
                } else if (c == '_') {
                    sb.append(' ');
                } else {
                    sb.append(c);
                }
                ++i;
            }
            return sb.toString();
        }

        static String emptyIsNull(String s) {
            if ((s = s.trim()).isEmpty()) {
                return null;
            }
            return s;
        }
    }
}

