/*
 * Decompiled with CFR 0.152.
 */
package aQute.rest.urlclient;

import aQute.lib.base64.Base64;
import aQute.lib.converter.TypeReference;
import aQute.lib.io.IO;
import aQute.lib.json.JSONCodec;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class URLClient {
    private static final String X_A_QUTE_AUTHORIZATION = "X-aQute-Authorization";
    static SimpleDateFormat httpFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH);
    static JSONCodec codec = new JSONCodec();
    final String url;
    List<String> cookies = new ArrayList<String>();
    private Reporter reporter;
    private String email;
    private String machine;
    private PrivateKey privateKey;
    private PublicKey publicKey;

    static {
        try {
            Method m = JSONCodec.class.getMethod("setHex", Boolean.TYPE);
            m.invoke((Object)codec, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public URLClient(String baseurl) {
        this.url = baseurl.endsWith("/") ? baseurl : String.valueOf(baseurl) + "/";
    }

    <X> X send(String verb, String path, Object to, TypeReference<X> ref, Map<String, List<String>> arguments) throws Exception {
        return (X)this.send(verb, path, to, ref.getType(), arguments);
    }

    <X> X send(String verb, String path, Object to, Class<X> ref, Map<String, List<String>> arguments) throws Exception {
        return (X)this.send(verb, path, to, (Type)ref, arguments);
    }

    Object send(String verb, String path, Object to, Type ref, Map<String, List<String>> arguments) throws Exception {
        StringBuilder sb = new StringBuilder(this.url);
        if (path != null) {
            sb.append(path);
        }
        if (arguments != null) {
            String del = "?";
            for (Map.Entry<String, List<String>> e : arguments.entrySet()) {
                for (String o : e.getValue()) {
                    sb.append(del);
                    del = "&";
                    sb.append(e.getKey());
                    sb.append('=');
                    sb.append(URLEncoder.encode(o.toString(), "UTF-8"));
                }
            }
        }
        URL url = new URL(sb.toString());
        try {
            Object object;
            int result;
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod(verb);
            if (to != null) {
                con.setDoOutput(true);
            }
            con.setRequestProperty("Accept-Encoding", "deflate, gzip");
            this.sign(con);
            if (to != null) {
                OutputStream out = con.getOutputStream();
                if (to instanceof InputStream) {
                    IO.copy((InputStream)to, out);
                } else if (to instanceof byte[]) {
                    IO.copy((byte[])to, out);
                } else if (to instanceof File) {
                    IO.copy((File)to, out);
                } else {
                    this.trace("-> " + to);
                    codec.enc().to(out).put(to).flush();
                }
                out.close();
                this.trace("Sentx ");
            }
            if ((result = con.getResponseCode()) / 100 != 2) {
                this.trace("Error ");
                String s = "";
                InputStream in = con.getErrorStream();
                if (in != null) {
                    s = IO.collect(in);
                }
                if (result == 404) {
                    this.trace("not found ");
                    return null;
                }
                throw new Exception("Failed request " + result + ":" + con.getResponseMessage() + " " + s);
            }
            InputStream in = con.getInputStream();
            try {
                Map<String, List<String>> headerFields;
                List<String> l;
                this.trace("receiving ");
                String encoding = con.getHeaderField("Content-Encoding");
                if (encoding != null) {
                    if (encoding.equalsIgnoreCase("deflate")) {
                        in = new InflaterInputStream(in);
                        this.trace("inflate");
                    } else if (encoding.equalsIgnoreCase("gzip")) {
                        in = new GZIPInputStream(in);
                        this.trace("gzip");
                    }
                }
                if ((l = (headerFields = con.getHeaderFields()).get("Set-Cookie")) != null) {
                    for (String c : l) {
                        this.cookies.add(c);
                    }
                }
                String s = IO.collect(in);
                this.trace("got " + s);
                object = codec.dec().from(s).get(ref);
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (Exception e) {
                    throw new Exception(url.toExternalForm(), e);
                }
            }
            in.close();
            return object;
        }
        finally {
            this.trace("<- " + url);
        }
    }

    private void trace(String string) {
        if (this.getReporter() != null) {
            this.getReporter().trace(string, new Object[0]);
        }
    }

    public void put(String path, Object to) throws Exception {
        this.send("PUT", path, to, (Type)null, (Map<String, List<String>>)null);
    }

    public <T> T put(String path, Object to, Type type, Map<String, List<String>> args) throws Exception {
        return (T)this.send("PUT", path, to, type, args);
    }

    public <T> T get(String path, Type type, Map<String, List<String>> args) throws Exception {
        return (T)this.send("GET", path, null, type, args);
    }

    public Reporter getReporter() {
        return this.reporter;
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public void credentials(String email, String machine, byte[] publicKey, byte[] privateKey) throws Exception {
        this.email = email;
        this.machine = machine;
        if (publicKey != null && privateKey != null) {
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(privateKey);
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(publicKey);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.privateKey = keyFactory.generatePrivate(privateKeySpec);
            this.publicKey = keyFactory.generatePublic(publicKeySpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sign(URLConnection connection) throws Exception {
        if (this.publicKey == null || this.email == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.email).append("!");
        if (this.machine != null) {
            sb.append(this.machine);
        }
        sb.append("!").append(Base64.encodeBase64(this.publicKey.getEncoded())).append(":");
        String dateHeader = connection.getRequestProperty("Date");
        SimpleDateFormat simpleDateFormat = httpFormat;
        synchronized (simpleDateFormat) {
            dateHeader = httpFormat.format(new Date());
        }
        connection.setRequestProperty("Date", dateHeader);
        Signature hmac = Signature.getInstance("SHA1withRSA");
        hmac.initSign(this.privateKey);
        hmac.update(dateHeader.getBytes());
        sb.append(Base64.encodeBase64(hmac.sign()));
        connection.setRequestProperty(X_A_QUTE_AUTHORIZATION, sb.toString());
    }

    public String getUrl() {
        return this.url;
    }

    public String getEmail() {
        return this.email;
    }

    public URI getUri(String path) throws URISyntaxException {
        return new URI(String.valueOf(this.url) + path);
    }
}

