/*
 * Decompiled with CFR 0.152.
 */
package aQute.p2.provider;

import aQute.lib.converter.Converter;
import aQute.lib.converter.TypeReference;
import aQute.lib.filter.Filter;
import aQute.libg.sed.Domain;
import aQute.libg.sed.ReplacerAdapter;
import aQute.p2.api.Artifact;
import aQute.p2.provider.XML;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Version;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ArtifactRepository
extends XML {
    List<Rule> rules;
    List<Artifact> artifacts = new ArrayList<Artifact>();
    private URI base;

    ArtifactRepository(InputStream in, URI base) throws Exception {
        super(ArtifactRepository.getDocument(in));
        this.base = base;
        this.parse();
    }

    private Rule createRule(Node ruleNode) {
        String filter = this.getAttribute(ruleNode, "filter");
        String output = this.getAttribute(ruleNode, "output");
        return new Rule(filter, output);
    }

    void parse() throws Exception {
        final Map<String, String> properties = this.getProperties("repository/properties/property");
        properties.put("repoUrl", this.base.resolve("").toString());
        final Domain parent = new Domain(){

            @Override
            public Map<String, String> getMap() {
                return properties;
            }

            @Override
            public Domain getParent() {
                return null;
            }
        };
        this.rules = this.getRules();
        NodeList artifactNodes = this.getNodes("repository/artifacts/artifact");
        block0: for (int i = 0; i < artifactNodes.getLength(); ++i) {
            XMLArtifact xmlArtifact = this.getFromType(artifactNodes.item(i), XMLArtifact.class);
            final Map<String, String> map = Converter.cnv(new TypeReference<Map<String, String>>(){}, (Object)xmlArtifact);
            if (!"osgi.bundle".equals(xmlArtifact.classifier)) continue;
            Domain domain = new Domain(){

                @Override
                public Map<String, String> getMap() {
                    return map;
                }

                @Override
                public Domain getParent() {
                    return parent;
                }
            };
            ReplacerAdapter ra = new ReplacerAdapter(domain);
            for (Rule r : this.rules) {
                if (!r.matches(map)) continue;
                String s = ra.process(r.output);
                URI uri = new URI(s).normalize();
                Artifact artifact = new Artifact();
                artifact.uri = uri;
                artifact.id = xmlArtifact.id;
                artifact.version = new Version(xmlArtifact.version);
                this.artifacts.add(artifact);
                continue block0;
            }
        }
    }

    List<Rule> getRules() throws Exception {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        NodeList ruleNodes = this.getNodes("repository/mappings/rule");
        for (int i = 0; i < ruleNodes.getLength(); ++i) {
            Node ruleNode = ruleNodes.item(i);
            Rule rule = this.createRule(ruleNode);
            rules.add(rule);
        }
        return rules;
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public static class XMLArtifact {
        public String classifier;
        public String id;
        public String version;
        public String format;
    }

    static class Rule {
        final Filter filter;
        String output;

        Rule(String filter, String output) {
            this.filter = new Filter(filter);
            this.output = output;
        }

        public boolean matches(Map<String, String> map) throws Exception {
            return this.filter.matchMap(map);
        }
    }
}

