/*
 * Decompiled with CFR 0.152.
 */
package aQute.jsonrpc.proxy;

import aQute.jsonrpc.domain.JSON;
import aQute.jsonrpc.proxy.JSONRpcException;
import aQute.lib.collections.ExtList;
import aQute.lib.converter.Converter;
import aQute.lib.hex.Hex;
import aQute.lib.json.JSONCodec;
import aQute.rest.urlclient.URLClient;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicLong;

public class JSONRPCProxy
implements InvocationHandler {
    public static final String JSONRPC_2_0 = "jsonrpc/2.0/";
    static AtomicLong counter = new AtomicLong(System.currentTimeMillis());
    static JSONCodec codec = new JSONCodec();
    static Converter converter = new Converter();
    static ThreadLocal<Future<?>> lastcall = new ThreadLocal();
    final URLClient host;
    final String endpoint;
    private final Executor executor;

    static {
        converter.hook((Type)((Object)byte[].class), new Converter.Hook(){

            @Override
            public Object convert(Type dest, Object o) throws Exception {
                if (o instanceof String) {
                    return Hex.toByteArray((String)o);
                }
                return null;
            }
        });
    }

    private JSONRPCProxy(URLClient host, String endpoint, Executor executor) {
        this.endpoint = endpoint;
        this.host = host;
        this.executor = executor;
    }

    public static <T> T createRPC(Class<T> interf, URLClient host, String endpoint) throws Exception {
        return JSONRPCProxy.createRPC(interf, host, endpoint, null);
    }

    public static <T> T createRPC(Class<T> interf, URLClient host, String endpoint, Executor executor) throws Exception {
        return (T)Proxy.newProxyInstance(interf.getClassLoader(), new Class[]{interf}, (InvocationHandler)new JSONRPCProxy(host, endpoint, executor));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.executor != null) {
            return this.invokeAsync(proxy, method, args);
        }
        return this.invokeSync(proxy, method, args);
    }

    private <Y> Y invokeAsync(final Object proxy, final Method method, final Object[] args) throws Exception {
        FutureTask task = new FutureTask(new Callable<Y>(){

            @Override
            public Y call() throws Exception {
                try {
                    return JSONRPCProxy.this.invokeSync(proxy, method, args);
                }
                catch (Throwable e) {
                    throw new InvocationTargetException(e);
                }
            }
        });
        this.executor.execute(task);
        lastcall.set(task);
        return (Y)converter.convert(method.getGenericReturnType(), null);
    }

    private <Y> Y invokeSync(Object proxy, Method method, Object[] args) throws Exception {
        JSON.Request request = new JSON.Request();
        request.id = counter.incrementAndGet();
        request.method = method.getName();
        request.params = new ExtList<Object>(args);
        JSON.Response response = (JSON.Response)this.host.put(JSONRPC_2_0 + this.endpoint, request, (Type)((Object)JSON.Response.class), null);
        if (response == null) {
            throw new FileNotFoundException("Not found url endpoint: " + this.host.getUrl());
        }
        if (response.error != null) {
            throw new JSONRpcException(response.error);
        }
        if (method.getReturnType() == Void.TYPE || method.getReturnType() == Void.class || response.result == null) {
            return null;
        }
        return (Y)converter.convert(method.getGenericReturnType(), response.result);
    }

    public static <T> Future<T> async(T returnValue) {
        return lastcall.get();
    }
}

