/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repository.p2.provider;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.build.Workspace;
import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.repository.BaseRepository;
import aQute.bnd.repository.p2.provider.P2Config;
import aQute.bnd.repository.p2.provider.P2Indexer;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.version.Version;
import aQute.lib.converter.Converter;
import aQute.lib.io.IO;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

@BndPlugin(name="p2", parameters=P2Config.class)
public class P2Repository
extends BaseRepository
implements Plugin,
RegistryPlugin,
RepositoryPlugin,
Refreshable,
Closeable {
    private P2Config config;
    private Registry registry;
    private Workspace workspace;
    private P2Indexer p2Index;
    private Reporter reporter;
    private String name;

    public File get(String bsn, Version version, Map<String, String> properties, RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        return this.getP2Index().get(bsn, version, properties, listeners);
    }

    private synchronized P2Indexer getP2Index() {
        if (this.p2Index != null) {
            return this.p2Index;
        }
        this.p2Index = this.getP2Index0();
        return this.p2Index;
    }

    P2Indexer getP2Index0() {
        this.workspace = (Workspace)this.registry.getPlugin(Workspace.class);
        HttpClient client = (HttpClient)this.registry.getPlugin(HttpClient.class);
        URI url = this.config.url();
        if (url == null) {
            throw new IllegalArgumentException("For a p2 repository you must set the url parameter to the repository");
        }
        try {
            this.name = this.config.name(client.toName(url));
            File location = this.workspace.getFile(this.config.location("cnf/cache/p2-" + this.name));
            location.mkdirs();
            File indexFile = new File(location, "index.xml.gz");
            return new P2Indexer(this.reporter, location, client, url, this.name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canWrite() {
        return false;
    }

    public List<String> list(String pattern) throws Exception {
        return this.getP2Index().list(pattern);
    }

    public SortedSet<Version> versions(String bsn) throws Exception {
        return this.getP2Index().versions(bsn);
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.getP2Index().location.getPath();
    }

    public void setProperties(Map<String, String> map) throws Exception {
        this.config = Converter.cnv(P2Config.class, map);
        this.name = this.config.name("p2-" + this.config.url());
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public boolean refresh() throws Exception {
        this.getP2Index().refresh();
        return true;
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        return this.getP2Index().getBridge().getRepository().findProviders(requirements);
    }

    public File getRoot() throws Exception {
        return this.getP2Index().location;
    }

    public RepositoryPlugin.PutResult put(InputStream stream, RepositoryPlugin.PutOptions options) throws Exception {
        throw new UnsupportedOperationException("Cannot write to a p2 repo ");
    }

    @Override
    public void close() throws IOException {
        IO.close(this.p2Index);
    }
}

