/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repository.osgi;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.build.Workspace;
import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.repository.BaseRepository;
import aQute.bnd.repository.osgi.OSGiIndex;
import aQute.bnd.service.Actionable;
import aQute.bnd.service.Plugin;
import aQute.bnd.service.Refreshable;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.RepositoryListenerPlugin;
import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.repository.Prepare;
import aQute.bnd.util.repository.DownloadListenerPromise;
import aQute.bnd.version.Version;
import aQute.lib.converter.Converter;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.libg.reporter.slf4j.Slf4jReporter;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.util.promise.Promise;

@BndPlugin(name="OSGiRepository", parameters=aQute.configurable.Config.class)
public class OSGiRepository
extends BaseRepository
implements Plugin,
RepositoryPlugin,
Actionable,
Refreshable,
RegistryPlugin,
Prepare,
Closeable {
    static final int YEAR = 31536000;
    static int DEFAULT_POLL_TIME = (int)TimeUnit.MINUTES.toSeconds(5L);
    private Config config;
    private OSGiIndex index;
    private Reporter reporter = new Slf4jReporter(OSGiRepository.class);
    private Registry registry;
    private ScheduledFuture<?> poller;
    private volatile boolean stale = false;
    private final AtomicBoolean inPoll = new AtomicBoolean();

    public RepositoryPlugin.PutResult put(InputStream stream, RepositoryPlugin.PutOptions options) throws Exception {
        throw new UnsupportedOperationException("Read only");
    }

    public File get(String bsn, Version version, Map<String, String> properties, RepositoryPlugin.DownloadListener ... listeners) throws Exception {
        File target = IO.getFile(this.getIndex().getCache(), bsn + "-" + version + ".jar");
        Promise<File> promise = this.getIndex().get(bsn, version, target);
        if (promise == null) {
            return null;
        }
        if (listeners.length == 0) {
            return (File)promise.getValue();
        }
        new DownloadListenerPromise(this.reporter, "Download " + bsn + "-" + version + " into " + this.config.name(), promise, listeners);
        return target;
    }

    private synchronized OSGiIndex getIndex() throws Exception {
        if (this.index != null) {
            return this.index;
        }
        return this.getIndex(false);
    }

    synchronized OSGiIndex getIndex(boolean refresh) throws Exception {
        int polltime;
        String cachePath;
        File cache;
        HttpClient client = (HttpClient)this.registry.getPlugin(HttpClient.class);
        Workspace ws = (Workspace)this.registry.getPlugin(Workspace.class);
        if (ws == null) {
            ws = Workspace.createDefaultWorkspace();
        }
        File file = cache = (cachePath = this.config.cache()) == null ? ws.getCache(this.config.name()) : ws.getFile(cachePath);
        if (refresh) {
            IO.delete(cache);
        }
        List<String> strings = Strings.split(this.config.locations());
        ArrayList<URI> urls = new ArrayList<URI>(strings.size());
        for (String s : strings) {
            urls.add(new URI(s));
        }
        if (!(this.poller != null || ws.getGestalt().containsKey("batch") || ws.getGestalt().containsKey("ci") || ws.getGestalt().containsKey("offline") || (polltime = this.config.poll_time(DEFAULT_POLL_TIME)) <= 0)) {
            this.poller = Processor.getScheduledExecutor().scheduleAtFixedRate(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (OSGiRepository.this.inPoll.getAndSet(true)) {
                        return;
                    }
                    try {
                        OSGiRepository.this.poll();
                    }
                    catch (Exception e) {
                        OSGiRepository.this.reporter.trace("During polling %s", new Object[]{e});
                    }
                    finally {
                        OSGiRepository.this.inPoll.set(false);
                    }
                }
            }, polltime, polltime, TimeUnit.SECONDS);
        }
        this.index = new OSGiIndex(this.config.name(), client, cache, urls, this.config.max_stale(31536000), refresh);
        this.stale = false;
        return this.index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void poll() throws Exception {
        OSGiIndex ix;
        if (this.stale) {
            return;
        }
        OSGiRepository oSGiRepository = this;
        synchronized (oSGiRepository) {
            ix = this.index;
        }
        if (ix == null) {
            return;
        }
        if (ix.isStale()) {
            this.stale = true;
            for (RepositoryListenerPlugin rp : this.registry.getPlugins(RepositoryListenerPlugin.class)) {
                rp.repositoryRefreshed((RepositoryPlugin)this);
            }
        }
    }

    public boolean canWrite() {
        return false;
    }

    public List<String> list(String pattern) throws Exception {
        return this.getIndex().getBridge().list(pattern);
    }

    public SortedSet<Version> versions(String bsn) throws Exception {
        return this.getIndex().getBridge().versions(bsn);
    }

    public String getName() {
        return this.config.name();
    }

    public String getLocation() {
        return this.config.locations();
    }

    public Map<String, Runnable> actions(final Object ... target) throws Exception {
        LinkedHashMap<String, Runnable> menu = new LinkedHashMap<String, Runnable>();
        switch (target.length) {
            case 0: {
                menu.put("Reload Index & Bundles", new Runnable(){

                    @Override
                    public void run() {
                        try {
                            OSGiRepository.this.getIndex(true);
                        }
                        catch (Exception e) {
                            throw Exceptions.duck(e);
                        }
                    }
                });
                break;
            }
            case 2: {
                menu.put("Reload Bundle", new Runnable(){

                    @Override
                    public void run() {
                        try {
                            String bsn = (String)target[0];
                            Version version = (Version)target[1];
                            File f = OSGiRepository.this.get(bsn, version, null, new RepositoryPlugin.DownloadListener[0]);
                            if (f != null) {
                                IO.delete(f);
                            }
                        }
                        catch (Exception e) {
                            throw Exceptions.duck(e);
                        }
                    }
                });
            }
        }
        return menu;
    }

    public String tooltip(Object ... target) throws Exception {
        if (target.length == 0) {
            try (Formatter f = new Formatter();){
                if (this.stale) {
                    f.format("[stale] Needs reload, see menu\n", new Object[0]);
                }
                f.format("Name             : %s\n", this.getName());
                f.format("Cache            : %s\n", this.getRoot());
                f.format("Max stale (secs) : %s\n", this.config.max_stale(31536000));
                f.format("\nURLs            :\n", new Object[0]);
                for (URI uri : this.getIndex().getURIs()) {
                    f.format("    %s\n", uri);
                }
                String string = f.toString();
                return string;
            }
        }
        return this.getIndex().getBridge().tooltip(target);
    }

    public String title(Object ... target) throws Exception {
        if (target.length == 0 && this.stale) {
            return this.getName() + " [stale]";
        }
        return this.getIndex().getBridge().title(target);
    }

    public synchronized boolean refresh() throws Exception {
        this.getIndex(false);
        return true;
    }

    public File getRoot() throws Exception {
        return this.getIndex().getCache();
    }

    public void setProperties(Map<String, String> map) throws Exception {
        this.config = Converter.cnv(Config.class, map);
    }

    public void setReporter(Reporter processor) {
        this.reporter = processor;
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void prepare() throws Exception {
        this.getIndex();
    }

    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ScheduledFuture<?> p;
        OSGiRepository oSGiRepository = this;
        synchronized (oSGiRepository) {
            p = this.poller;
        }
        if (p != null) {
            p.cancel(true);
        }
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        try {
            return this.getIndex().findProviders(requirements);
        }
        catch (Exception e) {
            throw Exceptions.duck(e);
        }
    }

    static interface Config {
        public String locations();

        public int max_stale(int var1);

        public String cache();

        public String name();

        public int poll_time(int var1);
    }
}

