/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repository.osgi;

import aQute.bnd.http.HttpClient;
import aQute.bnd.http.HttpRequest;
import aQute.bnd.osgi.repository.BridgeRepository;
import aQute.bnd.osgi.repository.ResourcesRepository;
import aQute.bnd.osgi.resource.ResourceUtils;
import aQute.bnd.service.url.TaggedData;
import aQute.bnd.version.Version;
import aQute.lib.exceptions.Exceptions;
import aQute.libg.reporter.slf4j.Slf4jReporter;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;
import org.osgi.util.function.Function;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Failure;
import org.osgi.util.promise.Promise;
import org.osgi.util.promise.Promises;
import org.osgi.util.promise.Success;

class OSGiIndex {
    private final Reporter log = new Slf4jReporter(OSGiIndex.class);
    private final Promise<BridgeRepository> repository;
    private final HttpClient client;
    private final long staleTime;
    private final File cache;
    private final String name;
    private final Collection<URI> uris;

    OSGiIndex(String name, HttpClient client, File cache, Collection<URI> uris, int staleTime, boolean refresh) throws Exception {
        this.name = name;
        this.uris = uris;
        this.client = client;
        this.cache = OSGiIndex.checkCache(cache);
        this.staleTime = (long)staleTime * 1000L;
        this.repository = this.readIndexes(refresh);
    }

    private Promise<BridgeRepository> readIndexes(boolean refresh) throws Exception {
        ArrayList<Promise<List<Resource>>> promises = new ArrayList<Promise<List<Resource>>>(this.getURIs().size());
        for (URI uri : this.getURIs()) {
            promises.add(this.download(uri, refresh));
        }
        Promise all = Promises.all(promises);
        return all.map((Function)new Function<List<List<Resource>>, BridgeRepository>(){

            public BridgeRepository apply(List<List<Resource>> resources) {
                try {
                    ResourcesRepository rr = new ResourcesRepository();
                    for (List<Resource> p : resources) {
                        rr.addAll(p);
                    }
                    return new BridgeRepository((Repository)rr);
                }
                catch (Exception e) {
                    throw Exceptions.duck(e);
                }
            }
        });
    }

    private static File checkCache(File cache) {
        cache.mkdirs();
        if (!cache.isDirectory()) {
            throw new IllegalArgumentException("Cannot create directory for " + cache);
        }
        return cache;
    }

    private Promise<List<Resource>> download(final URI uri, boolean refresh) throws Exception {
        HttpRequest req = this.client.build().useCache(refresh ? -1L : this.staleTime);
        return req.async(uri).map((Function)new Function<File, List<Resource>>(){

            /*
             * Exception decompiling
             */
            public List<Resource> apply(File file) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
    }

    Promise<File> get(String bsn, Version version, File file) throws Exception {
        Resource resource = this.getBridge().get(bsn, version);
        if (resource == null) {
            return null;
        }
        ResourceUtils.ContentCapability content = ResourceUtils.getContentCapability(resource);
        if (content == null) {
            this.log.warning("%s: No content capability for %s", new Object[]{this.name, resource});
            return null;
        }
        URI url = content.url();
        if (url == null) {
            this.log.warning("%s: No content capability for %s", new Object[]{this.name, resource});
            return null;
        }
        return this.client.build().useCache(file, this.staleTime).async(url);
    }

    BridgeRepository getBridge() throws Exception {
        return (BridgeRepository)this.repository.getValue();
    }

    File getCache() {
        return this.cache;
    }

    boolean isStale() throws Exception {
        final Deferred freshness = new Deferred();
        ArrayList<Promise> promises = new ArrayList<Promise>(this.getURIs().size());
        for (final URI uri : this.getURIs()) {
            if (freshness.getPromise().isDone()) break;
            try {
                Promise async = this.client.build().useCache().asTag().async(uri);
                promises.add(async.then((Success)new Success<TaggedData, Void>(){

                    public Promise<Void> call(Promise<TaggedData> resolved) throws Exception {
                        switch (((TaggedData)resolved.getValue()).getState()) {
                            case OTHER: {
                                OSGiIndex.this.log.trace("Could not verify %s", new Object[]{uri});
                                break;
                            }
                            case UNMODIFIED: {
                                break;
                            }
                            default: {
                                OSGiIndex.this.log.trace("Found %s to be stale", new Object[]{uri});
                                freshness.fail((Throwable)new Exception("stale"));
                            }
                        }
                        return null;
                    }
                }, new Failure(){

                    public void fail(Promise<?> resolved) throws Exception {
                        OSGiIndex.this.log.trace("Could not verify %s: %s", new Object[]{uri, resolved.getFailure()});
                        freshness.fail(resolved.getFailure());
                    }
                }));
            }
            catch (Exception e) {
                this.log.trace("Checking stale status: %s: %s", new Object[]{uri, e});
            }
        }
        Promise all = Promises.all(promises);
        freshness.resolveWith(all);
        return freshness.getPromise().getFailure() != null;
    }

    Collection<URI> getURIs() {
        return this.uris;
    }

    Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) throws Exception {
        return this.getBridge().getRepository().findProviders(requirements);
    }

    static /* synthetic */ String access$000(OSGiIndex x0) {
        return x0.name;
    }
}

