/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repository.maven.provider;

import aQute.bnd.osgi.Jar;
import aQute.bnd.repository.maven.provider.IndexFile;
import aQute.bnd.repository.maven.provider.MavenBndRepository;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.io.IO;
import aQute.maven.api.Archive;
import aQute.maven.api.IPom;
import aQute.maven.api.MavenScope;
import aQute.maven.api.Program;
import aQute.maven.api.Revision;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.osgi.util.promise.Promise;

class RepoActions {
    private MavenBndRepository repo;

    RepoActions(MavenBndRepository mavenBndRepository) {
        this.repo = mavenBndRepository;
    }

    Map<String, Runnable> getProgramActions(final String bsn) throws Exception {
        LinkedHashMap<String, Runnable> map = new LinkedHashMap<String, Runnable>();
        map.put("Delete All from Index", new Runnable(){

            @Override
            public void run() {
                try {
                    ((RepoActions)RepoActions.this).repo.index.remove(bsn);
                }
                catch (Exception e) {
                    throw Exceptions.duck(e);
                }
            }
        });
        return map;
    }

    Map<String, Runnable> getRevisionActions(final IndexFile.BundleDescriptor bd) throws Exception {
        LinkedHashMap<String, Runnable> map = new LinkedHashMap<String, Runnable>();
        map.put("Clear from Cache", new Runnable(){

            @Override
            public void run() {
                File dir = ((RepoActions)RepoActions.this).repo.storage.toLocalFile(bd.archive).getParentFile();
                IO.delete(dir);
            }
        });
        map.put("Delete from Index", new Runnable(){

            @Override
            public void run() {
                try {
                    ((RepoActions)RepoActions.this).repo.index.remove(bd.archive);
                }
                catch (Exception e) {
                    throw Exceptions.duck(e);
                }
            }
        });
        map.put("Add Compile Dependencies", new Runnable(){

            @Override
            public void run() {
                try {
                    RepoActions.this.addDependency(bd.archive, MavenScope.compile);
                }
                catch (Exception e) {
                    throw Exceptions.duck(e);
                }
            }
        });
        map.put("Add Runtime Dependencies", new Runnable(){

            @Override
            public void run() {
                try {
                    RepoActions.this.addDependency(bd.archive, MavenScope.runtime);
                }
                catch (Exception e) {
                    throw Exceptions.duck(e);
                }
            }
        });
        map.put("Refresh", new Runnable(){

            @Override
            public void run() {
                try {
                    ((RepoActions)RepoActions.this).repo.index.updateAsync(bd.archive);
                }
                catch (Exception e) {
                    throw Exceptions.duck(e);
                }
            }
        });
        this.addUpdate(bd, map);
        this.addSources(bd, map);
        return map;
    }

    void addSources(IndexFile.BundleDescriptor bd, Map<String, Runnable> map) throws Exception {
        File sources;
        Archive a;
        Promise<File> pSources;
        File binary;
        File out;
        Promise<File> pBinary = this.repo.storage.get(bd.archive);
        if (pBinary.getFailure() == null && !(out = new File((binary = (File)pBinary.getValue()).getParentFile(), "+" + binary.getName())).isFile() && (pSources = this.repo.storage.get(a = bd.archive.revision.archive("jar", "sources"))).getFailure() == null && (sources = (File)pSources.getValue()).isFile() && sources.length() > 1000L) {
            map.put("Add Sources", new Runnable(){

                @Override
                public void run() {
                    try (Jar src = new Jar(sources);){
                        try (Jar bin = new Jar(binary);){
                            bin.setDoNotTouchManifest();
                            for (String path : src.getResources().keySet()) {
                                bin.putResource("OSGI-OPT/src/" + path, src.getResource(path));
                            }
                            bin.write(out);
                        }
                        out.setLastModified(System.currentTimeMillis());
                    }
                    catch (Exception e) {
                        throw Exceptions.duck(e);
                    }
                }
            });
            return;
        }
        map.put("-Add Sources", null);
    }

    void addUpdate(final IndexFile.BundleDescriptor bd, Map<String, Runnable> map) throws Exception {
        try {
            Revision rev = bd.archive.revision;
            Program prog = rev.program;
            List<Revision> revisions = this.repo.storage.getRevisions(prog);
            if (revisions.size() > 1) {
                final Revision last = revisions.get(revisions.size() - 1);
                if (!rev.equals(last)) {
                    map.put("Update to " + last, new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ((RepoActions)RepoActions.this).repo.index.remove(bd.archive);
                                ((RepoActions)RepoActions.this).repo.index.add(last.archive(bd.archive.extension, bd.archive.classifier));
                                RepoActions.this.addDependency(bd.archive, MavenScope.runtime);
                            }
                            catch (Exception e) {
                                throw Exceptions.duck(e);
                            }
                        }
                    });
                } else {
                    map.put("-Update", null);
                }
            }
        }
        catch (Exception e) {
            map.put("-Update [" + e + "]", null);
        }
    }

    private void addDependency(Archive archive, MavenScope scope) throws Exception {
        IPom pom = this.repo.storage.getPom(archive.revision);
        Map<Program, IPom.Dependency> dependencies = pom.getDependencies(scope, false);
        for (IPom.Dependency d : dependencies.values()) {
            IndexFile.BundleDescriptor add = this.repo.index.add(d.program.version(d.version).archive("jar", null));
            if (d.error == null) continue;
            add.error = d.error;
        }
    }
}

