/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repository.maven.pom.provider;

import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.repository.BridgeRepository;
import aQute.bnd.osgi.resource.CapabilityBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.libg.reporter.slf4j.Slf4jReporter;
import aQute.maven.api.Archive;
import aQute.maven.api.IPom;
import aQute.maven.api.MavenScope;
import aQute.maven.api.Program;
import aQute.maven.api.Revision;
import aQute.maven.provider.MavenRepository;
import aQute.maven.provider.POM;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.Version;
import org.osgi.resource.Resource;
import org.osgi.util.promise.Deferred;
import org.osgi.util.promise.Promise;

class Traverser {
    final Reporter reporter = new Slf4jReporter(Traverser.class);
    static final Resource DUMMY = new ResourceBuilder().build();
    static final String ROOT = "<>";
    final ConcurrentMap<Archive, Resource> resources = new ConcurrentHashMap<Archive, Resource>();
    final Executor executor;
    final Collection<Revision> revisions;
    final URI resource;
    final AtomicInteger count = new AtomicInteger(-1);
    final Deferred<Map<Archive, Resource>> deferred = new Deferred();
    final MavenRepository repo;
    final HttpClient client;

    Traverser(MavenRepository repo, Revision revision, HttpClient client, Executor executor) {
        this.repo = repo;
        this.revisions = Collections.singleton(revision);
        this.client = client;
        this.executor = executor;
        this.resource = null;
    }

    Traverser(MavenRepository repo, Collection<Revision> revisions, HttpClient client, Executor executor) {
        this.repo = repo;
        this.revisions = revisions;
        this.client = client;
        this.executor = executor;
        this.resource = null;
    }

    Traverser(MavenRepository repo, URI resource, HttpClient client, Executor executor) {
        this.repo = repo;
        this.client = client;
        this.revisions = null;
        this.executor = executor;
        this.resource = resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Promise<Map<Archive, Resource>> getResources() throws Exception {
        if (this.count.compareAndSet(-1, 1)) {
            try {
                if (this.resource != null) {
                    File in = (File)this.client.build().useCache().age(1, TimeUnit.DAYS).go(this.resource);
                    POM pom = new POM(this.repo, in);
                    this.parsePom(pom, ROOT);
                } else {
                    for (Revision revision : this.revisions) {
                        this.parse(revision.archive("jar", null), ROOT);
                    }
                }
            }
            finally {
                this.finish();
            }
        }
        return this.deferred.getPromise();
    }

    private void finish() {
        if (this.count.decrementAndGet() == 0) {
            this.deferred.resolve(this.prune(this.resources));
        }
    }

    private void parse(final Archive archive, final String parent) {
        Resource prev = this.resources.putIfAbsent(archive, DUMMY);
        if (prev != null) {
            return;
        }
        this.count.incrementAndGet();
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Traverser.this.reporter.trace("parse archive %s", new Object[]{archive});
                    Traverser.this.parseArchive(archive);
                }
                catch (Throwable throwable) {
                    Traverser.this.reporter.trace(" failed to parse archive %s: %s", new Object[]{archive, throwable});
                    ResourceBuilder rb = new ResourceBuilder();
                    String bsn = archive.revision.program.toString();
                    Version version = Traverser.this.toFrameworkVersion(archive.revision.version.getOSGiVersion());
                    Traverser.this.addReserveIdentity(rb, bsn, version);
                    BridgeRepository.addInformationCapability((ResourceBuilder)rb, (String)archive.toString(), (String)parent, (Throwable)throwable);
                    Traverser.this.resources.put(archive, rb.build());
                }
                finally {
                    Traverser.this.finish();
                }
            }
        });
    }

    private Version toFrameworkVersion(aQute.bnd.version.Version v) {
        return new Version(v.getMajor(), v.getMinor(), v.getMicro(), v.getQualifier());
    }

    private Map<Archive, Resource> prune(Map<Archive, Resource> resources) {
        Iterator<Map.Entry<Archive, Resource>> e = resources.entrySet().iterator();
        while (e.hasNext()) {
            Map.Entry<Archive, Resource> next = e.next();
            if (next.getValue() != DUMMY) continue;
            e.remove();
        }
        return resources;
    }

    private void parseArchive(Archive archive) throws Exception {
        POM pom = this.repo.getPom(archive.revision);
        String parent = archive.revision.toString();
        this.parsePom(pom, parent);
        if (!pom.isPomOnly()) {
            this.parseResource(archive, parent);
        }
    }

    private void parsePom(POM pom, String parent) throws Exception {
        Map<Program, IPom.Dependency> dependencies = pom.getDependencies(EnumSet.of(MavenScope.compile, MavenScope.runtime), false);
        for (IPom.Dependency d : dependencies.values()) {
            Archive archive = d.getArchive();
            if (archive == null) {
                this.reporter.trace("pom %s has bad dependency %s", new Object[]{pom.getRevision(), d});
                continue;
            }
            this.parse(archive, parent);
        }
    }

    private void parseResource(Archive archive, String parent) throws Exception {
        ResourceBuilder rb = new ResourceBuilder();
        Version frameworkVersion = this.toFrameworkVersion(archive.revision.version.getOSGiVersion());
        String bsn = archive.revision.program.toString();
        try {
            File binary = (File)this.repo.get(archive).getValue();
            if (!rb.addFile(binary, binary.toURI())) {
                this.addReserveIdentity(rb, bsn, frameworkVersion);
            }
            BridgeRepository.addInformationCapability((ResourceBuilder)rb, (String)archive.toString(), (String)parent, null);
        }
        catch (Exception e) {
            this.addReserveIdentity(rb, bsn, frameworkVersion);
            BridgeRepository.addInformationCapability((ResourceBuilder)rb, (String)archive.toString(), (String)parent, (Throwable)e);
        }
        this.resources.put(archive, rb.build());
    }

    private void addReserveIdentity(ResourceBuilder rb, String bsn, Version version) {
        try {
            CapabilityBuilder c = new CapabilityBuilder("osgi.identity");
            c.addAttribute("osgi.identity", bsn);
            c.addAttribute("version", version);
            c.addAttribute("type", "application/java-archive");
            rb.addCapability(c);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }
}

