/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.repository.maven.pom.provider;

import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.repository.XMLResourceGenerator;
import aQute.bnd.osgi.repository.XMLResourceParser;
import aQute.bnd.repository.maven.pom.provider.InnerRepository;
import aQute.bnd.repository.maven.pom.provider.Traverser;
import aQute.maven.api.Archive;
import aQute.maven.api.Revision;
import aQute.maven.provider.MavenRepository;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.osgi.resource.Resource;
import org.osgi.util.promise.Promise;

class SearchRepository
extends InnerRepository {
    static final long DEFAULT_MAX_STALE = TimeUnit.HOURS.toMillis(1L);
    final String query;
    final String queryUrl;
    final Reporter reporter;
    final HttpClient client;
    final File cacheFile;

    SearchRepository(MavenRepository repo, File location, String query, String queryUrl, Reporter reporter, HttpClient client) throws Exception {
        super(repo, location);
        this.query = query;
        this.queryUrl = queryUrl;
        this.reporter = reporter;
        this.client = client;
        this.cacheFile = new File(location.getParentFile(), "query.txt");
        this.read();
    }

    @Override
    void refresh() throws Exception {
        SearchResult result = this.query();
        Traverser traverser = new Traverser(this.getMavenRepository(), result.response.docsToRevisions(), null, Processor.getExecutor());
        Promise<Map<Archive, Resource>> p = traverser.getResources();
        Collection resources = ((Map)p.getValue()).values();
        this.set(resources);
        this.save(this.query, resources, this.getLocation());
    }

    void save(String revision, Collection<? extends Resource> resources, File location) throws Exception, IOException {
        XMLResourceGenerator generator = new XMLResourceGenerator();
        generator.resources(resources);
        generator.name(revision);
        generator.save(location);
    }

    void read() throws Exception {
        if (this.isStale()) {
            this.refresh();
        } else {
            try (XMLResourceParser parser = new XMLResourceParser(this.getLocation());){
                List resources = parser.parse();
                this.addAll(resources);
            }
        }
    }

    boolean isStale() {
        if (!this.getLocation().isFile()) {
            return true;
        }
        try {
            SearchResult result = this.query();
            if (result.getLastModified() > this.getLocation().lastModified()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    SearchResult query() throws Exception {
        URL url = new URL(this.queryUrl + '?' + this.query);
        int n = 0;
        while (true) {
            try {
                this.reporter.trace("Searching %s", new Object[]{this.query});
                SearchResult result = (SearchResult)this.client.build().headers("User-Agent", "Bnd").useCache(this.cacheFile, DEFAULT_MAX_STALE).get(SearchResult.class).go(url);
                this.reporter.trace("Searched %s", new Object[]{result});
                return result;
            }
            catch (Exception e) {
                if (++n > 3) {
                    throw e;
                }
                Thread.sleep(1000 * n);
                continue;
            }
            break;
        }
    }

    public static class Doc {
        public String id;
        public String g;
        public String a;
        public String v;
        public String latestVersion;
        public String repositoryId;
        public String p;
        public long timestamp;
        public int versionCount;
        public String[] ec;

        public String getVersion() {
            return this.v != null ? this.v : this.latestVersion;
        }

        public Revision toRevision() {
            return Revision.valueOf(this.toString());
        }

        public String toString() {
            return String.format("%s:%s:%s", this.g, this.a, this.getVersion());
        }
    }

    public static class Response {
        public long numFound;
        public long start;
        public Doc[] docs;
        List<Revision> list;

        public List<Revision> docsToRevisions() {
            if (this.list != null) {
                return this.list;
            }
            ArrayList<Revision> newList = new ArrayList<Revision>();
            for (Doc doc : this.docs) {
                newList.add(doc.toRevision());
            }
            this.list = newList;
            return this.list;
        }
    }

    public static class ResponseHeader {
        public Map<String, String> params;
    }

    public static class SearchResult {
        public ResponseHeader responseHeader;
        public Response response;

        public long getLastModified() {
            long timestamp = -1L;
            for (Doc doc : Arrays.asList(this.response.docs)) {
                if (doc.timestamp <= timestamp) continue;
                timestamp = doc.timestamp;
            }
            return timestamp;
        }
    }
}

