/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.deployer.repository.wrapper;

import aQute.bnd.build.Workspace;
import aQute.bnd.deployer.repository.wrapper.InfoRepositoryWrapper;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.repository.BaseRepository;
import aQute.bnd.osgi.resource.FilterParser;
import aQute.bnd.service.Registry;
import aQute.bnd.service.RegistryPlugin;
import aQute.bnd.service.repository.InfoRepository;
import aQute.lib.collections.MultiMap;
import aQute.lib.converter.Converter;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.io.IO;
import aQute.libg.reporter.ReporterAdapter;
import aQute.service.reporter.Reporter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.service.repository.Repository;

public class Plugin
extends BaseRepository
implements aQute.bnd.service.Plugin,
RegistryPlugin,
Repository,
Closeable {
    private Registry registry;
    private Config config;
    private Reporter reporter = new ReporterAdapter();
    private File dir;
    private InfoRepositoryWrapper wrapper;
    private boolean init = false;
    FilterParser fp = new FilterParser();

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setProperties(Map<String, String> map) throws Exception {
        this.config = Converter.cnv(Config.class, map);
        File file = IO.getFile(this.config.location());
        file.mkdirs();
        if (!file.isDirectory()) {
            this.reporter.error("Repository Wrapper: cannot create cache: %s", new Object[]{file});
        }
        this.dir = file;
    }

    public void setReporter(Reporter reporter) {
        this.reporter = reporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        block12: {
            if (this.init) {
                return;
            }
            this.init = true;
            try {
                ArrayList<InfoRepository> irs = new ArrayList<InfoRepository>();
                for (InfoRepository ir : this.registry.getPlugins(InfoRepository.class)) {
                    irs.add(ir);
                }
                this.wrapper = new InfoRepositoryWrapper(this.dir, irs);
                if (this.config.reindex()) {
                    this.wrapper.clear();
                }
                if (this.config.augments() == null) break block12;
                Workspace workspace = (Workspace)this.registry.getPlugin(Workspace.class);
                try (Processor p = new Processor((Processor)workspace);){
                    if (!this.config.augments().equals("WORKSPACE")) {
                        File f = IO.getFile(workspace.getBuildDir(), this.config.augments());
                        if (!f.isFile()) {
                            if (this.reporter != null) {
                                this.reporter.error("No augment file found at %s", new Object[]{f.getAbsolutePath()});
                            }
                            return;
                        }
                        p.setProperties(f);
                        this.wrapper.clear(f.lastModified());
                    }
                    this.wrapper.addAugment(p.getFlattenedProperties());
                    this.wrapper.clear(workspace.getPropertiesFile().lastModified());
                }
            }
            catch (Exception e) {
                throw Exceptions.duck(e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.wrapper == null) {
            return;
        }
        this.wrapper.close();
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        this.init();
        MultiMap<Requirement, Capability> result = new MultiMap<Requirement, Capability>();
        try {
            this.wrapper.findProviders(result, requirements);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public String toString() {
        return this.wrapper != null ? this.wrapper.toString() : "<wrapper not set>";
    }

    static interface Config {
        public String location();

        public boolean reindex();

        public String augments();
    }
}

