/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.deployer.repository.providers;

import aQute.bnd.deployer.repository.api.CheckResult;
import aQute.bnd.deployer.repository.api.Decision;
import aQute.bnd.deployer.repository.api.IRepositoryContentProvider;
import aQute.bnd.deployer.repository.api.IRepositoryIndexProcessor;
import aQute.bnd.deployer.repository.api.Referral;
import aQute.bnd.deployer.repository.providers.ObrUtil;
import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceBuilder;
import aQute.bnd.service.Registry;
import aQute.lib.io.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Set;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.osgi.framework.Version;
import org.osgi.resource.Resource;
import org.osgi.service.bindex.BundleIndexer;
import org.osgi.service.log.LogService;

public class ObrContentProvider
implements IRepositoryContentProvider {
    public static final String NAME = "OBR";
    private static final String INDEX_NAME = "repository.xml";
    private static final String EMPTY_REPO_TEMPLATE = "<?xml version='1.0' encoding='UTF-8'?>\n<repository name='%s' lastmodified='0' xmlns='http://www.osgi.org/xmlns/obr/v1.0.0'/>";
    private static final String NS_URI = "http://www.osgi.org/xmlns/obr/v1.0.0";
    private static final String PI_DATA_STYLESHEET = "type='text/xsl' href='http://www2.osgi.org/www/obr2html.xsl'";
    private static final String PI_TARGET_STYLESHEET = "xml-stylesheet";
    private static final String TAG_REPOSITORY = "repository";
    private static final String TAG_RESOURCE = "resource";
    private static final String ATTR_RESOURCE_SYMBOLIC_NAME = "symbolicname";
    private static final String ATTR_RESOURCE_URI = "uri";
    private static final String ATTR_RESOURCE_VERSION = "version";
    private static final String TAG_REFERRAL = "referral";
    private static final String ATTR_REFERRAL_URL = "url";
    private static final String ATTR_REFERRAL_DEPTH = "depth";
    private static final String TAG_CAPABILITY = "capability";
    private static final String TAG_REQUIRE = "require";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_EXTEND = "extend";
    private static final String ATTR_OPTIONAL = "optional";
    private static final String ATTR_FILTER = "filter";
    private static final String TAG_PROPERTY = "p";
    private static final String ATTR_PROPERTY_NAME = "n";
    private static final String ATTR_PROPERTY_TYPE = "t";
    private static final String ATTR_PROPERTY_VALUE = "v";
    private static final String PROPERTY_USES = "uses";
    private static final String TYPE_VERSION = "version";
    private BundleIndexer indexer;

    public ObrContentProvider(BundleIndexer indexer) {
        this.indexer = indexer;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDefaultIndexName(boolean pretty) {
        return INDEX_NAME;
    }

    @Override
    public void parseIndex(InputStream stream, URI baseUri, IRepositoryIndexProcessor listener, LogService log) throws Exception {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
        inputFactory.setProperty("javax.xml.stream.isValidating", false);
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        StreamSource source = new StreamSource(stream, baseUri.toString());
        XMLStreamReader reader = inputFactory.createXMLStreamReader(source);
        ResourceBuilder resourceBuilder = null;
        CapReqBuilder capReqBuilder = null;
        block4: while (reader.hasNext()) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String obrName;
                    String localName = reader.getLocalName();
                    if (TAG_REFERRAL.equals(localName)) {
                        Referral referral = new Referral(reader.getAttributeValue(null, ATTR_REFERRAL_URL), ObrContentProvider.parseInt(reader.getAttributeValue(null, ATTR_REFERRAL_DEPTH)));
                        listener.processReferral(baseUri, referral, referral.getDepth(), 1);
                        break;
                    }
                    if (TAG_RESOURCE.equals(localName)) {
                        resourceBuilder = new ResourceBuilder();
                        String bsn = reader.getAttributeValue(null, ATTR_RESOURCE_SYMBOLIC_NAME);
                        String versionStr = reader.getAttributeValue(null, "version");
                        Version version = Version.parseVersion(versionStr);
                        String uri = reader.getAttributeValue(null, ATTR_RESOURCE_URI);
                        URI resolvedUri = ObrContentProvider.resolveUri(uri, baseUri);
                        ObrContentProvider.addBasicCapabilities(resourceBuilder, bsn, version, resolvedUri);
                        break;
                    }
                    if (TAG_CAPABILITY.equals(localName)) {
                        obrName = reader.getAttributeValue(null, ATTR_NAME);
                        String namespace = ObrContentProvider.mapObrNameToR5Namespace(obrName, false);
                        capReqBuilder = new CapReqBuilder(namespace);
                        break;
                    }
                    if (TAG_REQUIRE.equals(localName)) {
                        obrName = reader.getAttributeValue(null, ATTR_NAME);
                        boolean extend = "true".equalsIgnoreCase(reader.getAttributeValue(null, ATTR_EXTEND));
                        String namespace = ObrContentProvider.mapObrNameToR5Namespace(obrName, extend);
                        boolean optional = "true".equalsIgnoreCase(reader.getAttributeValue(null, ATTR_OPTIONAL));
                        capReqBuilder = new CapReqBuilder(namespace);
                        if (optional) {
                            capReqBuilder.addDirective("resolution", ATTR_OPTIONAL);
                        }
                        String filter = ObrContentProvider.translateObrFilter(namespace, reader.getAttributeValue(null, ATTR_FILTER), log);
                        capReqBuilder.addDirective(ATTR_FILTER, filter);
                        break;
                    }
                    if (!TAG_PROPERTY.equals(localName)) break;
                    String name = reader.getAttributeValue(null, ATTR_PROPERTY_NAME);
                    String typeStr = reader.getAttributeValue(null, ATTR_PROPERTY_TYPE);
                    String valueStr = reader.getAttributeValue(null, ATTR_PROPERTY_VALUE);
                    if (capReqBuilder == null) continue block4;
                    name = ObrContentProvider.mapObrPropertyToR5(capReqBuilder.getNamespace(), name);
                    if (PROPERTY_USES.equals(name)) {
                        capReqBuilder.addDirective(PROPERTY_USES, valueStr);
                        break;
                    }
                    Object value = ObrContentProvider.convertProperty(valueStr, typeStr);
                    capReqBuilder.addAttribute(name, value);
                    break;
                }
                case 2: {
                    String localName = reader.getLocalName();
                    if (TAG_RESOURCE.equals(localName)) {
                        if (resourceBuilder == null) break;
                        Resource resource = resourceBuilder.build();
                        listener.processResource(resource);
                        break;
                    }
                    if (TAG_CAPABILITY.equals(localName)) {
                        if (resourceBuilder != null && capReqBuilder != null) {
                            resourceBuilder.addCapability(capReqBuilder);
                        }
                        capReqBuilder = null;
                        break;
                    }
                    if (!TAG_REQUIRE.equals(localName)) break;
                    if (resourceBuilder != null && capReqBuilder != null) {
                        resourceBuilder.addRequirement(capReqBuilder);
                    }
                    capReqBuilder = null;
                }
            }
        }
    }

    private static Object convertProperty(String value, String typeName) {
        Object result = "version".equals(typeName) ? Version.parseVersion(value) : value;
        return result;
    }

    private static String mapObrNameToR5Namespace(String obrName, boolean extend) {
        if ("bundle".equals(obrName)) {
            return extend ? "osgi.wiring.host" : "osgi.wiring.bundle";
        }
        if ("package".equals(obrName)) {
            return "osgi.wiring.package";
        }
        if ("service".equals(obrName)) {
            return "osgi.service";
        }
        if ("ee".equals(obrName)) {
            return "osgi.ee";
        }
        return obrName;
    }

    private static String translateObrFilter(String namespace, String filter, LogService log) {
        filter = ObrUtil.processFilter(filter, log);
        if ("osgi.wiring.package".equals(namespace)) {
            return filter.replaceAll("\\(package", "(osgi.wiring.package");
        }
        if ("osgi.service".equals(namespace)) {
            return filter.replaceAll("\\(service", "(osgi.service");
        }
        if ("osgi.wiring.bundle".equals(namespace)) {
            filter = filter.replaceAll("\\(symbolicname", "(osgi.wiring.bundle");
            return filter.replaceAll("\\(version", "(bundle-version");
        }
        if ("osgi.ee".equals(namespace)) {
            return filter.replaceAll("\\(ee", "(osgi.ee");
        }
        return filter;
    }

    private static String mapObrPropertyToR5(String namespace, String propName) {
        if ("osgi.wiring.bundle".equals(namespace)) {
            if (ATTR_RESOURCE_SYMBOLIC_NAME.equals(propName)) {
                return "osgi.wiring.bundle";
            }
            if ("version".equals(propName)) {
                return "bundle-version";
            }
        }
        if ("osgi.wiring.package".equals(namespace) && "package".equals(propName)) {
            return "osgi.wiring.package";
        }
        if ("osgi.service".equals(namespace) && "service".equals(propName)) {
            return "osgi.service";
        }
        return propName;
    }

    private static URI resolveUri(String uriStr, URI baseUri) throws URISyntaxException {
        URI resourceUri = new URI(uriStr);
        URI resolved = resourceUri.isAbsolute() ? resourceUri : baseUri.resolve(resourceUri);
        return resolved;
    }

    private static void addBasicCapabilities(ResourceBuilder builder, String bsn, Version version, URI resolvedUri) throws Exception {
        CapReqBuilder identity = new CapReqBuilder("osgi.identity").addAttribute("osgi.identity", bsn).addAttribute("type", "osgi.bundle").addAttribute("version", version);
        CapReqBuilder content = new CapReqBuilder("osgi.content").addAttribute(ATTR_REFERRAL_URL, resolvedUri);
        CapReqBuilder host = new CapReqBuilder("osgi.wiring.host").addAttribute("osgi.wiring.host", bsn).addAttribute("bundle-version", version);
        builder.addCapability(identity).addCapability(content).addCapability(host);
    }

    private static int parseInt(String value) {
        if (value == null || "".equals(value)) {
            return 0;
        }
        return Integer.parseInt(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public CheckResult checkStream(String name, InputStream stream) throws IOException {
        XMLStreamReader reader = null;
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            inputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
            inputFactory.setProperty("javax.xml.stream.isValidating", false);
            inputFactory.setProperty("javax.xml.stream.supportDTD", false);
            reader = inputFactory.createXMLStreamReader(stream);
            ParserState state = ParserState.beforeRoot;
            block37: while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 3: {
                        if (!PI_TARGET_STYLESHEET.equals(reader.getPITarget()) || !PI_DATA_STYLESHEET.equals(reader.getPIData())) break;
                        CheckResult checkResult = new CheckResult(Decision.accept, "Recognised stylesheet", null);
                        return checkResult;
                    }
                    case 1: {
                        String localName = reader.getLocalName();
                        switch (state) {
                            case beforeRoot: {
                                String nsUri = reader.getNamespaceURI();
                                if (nsUri != null) {
                                    CheckResult checkResult = CheckResult.fromBool(NS_URI.equals(nsUri), "Correct namespace on root element", "Incorrect namespace on root element: " + nsUri, null);
                                    return checkResult;
                                }
                                if (!TAG_REPOSITORY.equals(localName)) {
                                    CheckResult checkResult = new CheckResult(Decision.reject, "Incorrect root element name", null);
                                    return checkResult;
                                }
                                state = ParserState.inRoot;
                                break;
                            }
                            case inRoot: {
                                if (TAG_RESOURCE.equals(localName)) {
                                    state = ParserState.inResource;
                                    break;
                                }
                                if (TAG_REFERRAL.equals(localName)) continue block37;
                                CheckResult checkResult = new CheckResult(Decision.reject, String.format("Incorrect element '%s', expected '%s' or '%s'.", localName, TAG_RESOURCE, TAG_REFERRAL), null);
                                return checkResult;
                            }
                            case inResource: {
                                if (!TAG_CAPABILITY.equals(localName)) continue block37;
                                state = ParserState.inCapability;
                                break;
                            }
                            case inCapability: {
                                CheckResult checkResult = CheckResult.fromBool(TAG_PROPERTY.equals(localName), "Found 'p' tag inside 'capability'", String.format("Incorrect element '%s' inside '%s'; expected '%s'.", localName, TAG_CAPABILITY, TAG_PROPERTY), null);
                                return checkResult;
                            }
                        }
                        break;
                    }
                    case 2: {
                        String localName = reader.getLocalName();
                        if (state == ParserState.inResource && TAG_RESOURCE.equals(localName)) {
                            state = ParserState.inRoot;
                        }
                        if (state != ParserState.inCapability || !TAG_CAPABILITY.equals(localName)) break;
                        state = ParserState.inResource;
                        continue block37;
                    }
                }
            }
            CheckResult type = new CheckResult(Decision.undecided, "Reached end of stream", null);
            return type;
        }
        catch (XMLStreamException e) {
            CheckResult checkResult = new CheckResult(Decision.reject, "Invalid XML", e);
            return checkResult;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {}
            }
        }
    }

    @Override
    public boolean supportsGeneration() {
        return true;
    }

    @Override
    public void generateIndex(Set<File> files, OutputStream output, String repoName, URI rootUri, boolean pretty, Registry registry, LogService log) throws Exception {
        if (!files.isEmpty()) {
            if (this.indexer == null) {
                throw new IllegalStateException("Cannot index repository: no Bundle Indexer provided.");
            }
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("repository.name", repoName);
            config.put("root.url", rootUri.toString());
            this.indexer.index(files, output, config);
        } else {
            String content = String.format(EMPTY_REPO_TEMPLATE, repoName);
            IO.copy(IO.stream(content), output);
        }
    }

    private static enum ParserState {
        beforeRoot,
        inRoot,
        inResource,
        inCapability;

    }
}

