/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.jdi;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.jetbrains.debugger.jdi.AsyncResultCommand;
import com.jetbrains.debugger.jdi.JdiValueManager;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.TypeComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariablesHost;
import org.jetbrains.debugger.values.ObjectValueBase;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

public class JdiObject
extends ObjectValueBase<JdiValueManager> {
    protected final ObjectReference objectReference;
    protected VariablesHost<JdiValueManager> childrenManager;

    @NotNull
    protected VariablesHost<JdiValueManager> getChildrenManager() {
        VariablesHost<JdiValueManager> variablesHost = this.childrenManager;
        if (variablesHost == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiObject", "getChildrenManager"));
        }
        return variablesHost;
    }

    public JdiObject(@NotNull ValueType type, @NotNull ObjectReference objectReference, @NotNull JdiValueManager valueManager) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/debugger/jdi/JdiObject", "<init>"));
        }
        if (objectReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectReference", "com/jetbrains/debugger/jdi/JdiObject", "<init>"));
        }
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "com/jetbrains/debugger/jdi/JdiObject", "<init>"));
        }
        super(type);
        this.objectReference = objectReference;
        this.initChildManager(valueManager);
    }

    protected void initChildManager(@NotNull JdiValueManager valueManager) {
        if (valueManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueManager", "com/jetbrains/debugger/jdi/JdiObject", "initChildManager"));
        }
        this.childrenManager = new VariablesHost<JdiValueManager>(valueManager){

            @NotNull
            protected Promise<List<Variable>> load() {
                AsyncPromise promise = new AsyncPromise();
                ((JdiValueManager)this.valueManager).getManagerThread().schedule((DebuggerCommandImpl)new AsyncResultCommand<List<Variable>>(promise){

                    @Override
                    protected void doAction() throws Exception {
                        List<Field> allFields = JdiObject.this.objectReference.referenceType().allFields();
                        if (allFields.isEmpty()) {
                            this.updateCacheStamp();
                            this.promise.setResult(Collections.emptyList());
                            return;
                        }
                        ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
                        SmartList fields = new SmartList();
                        for (Field field : allFields) {
                            if (!JdiObject.shouldDisplay(classRenderer, field)) continue;
                            fields.add(field);
                        }
                        ArrayList<VariableImpl> variables = new ArrayList<VariableImpl>(fields.size());
                        Map<Field, com.sun.jdi.Value> fieldToValue = JdiObject.this.objectReference.getValues((List<? extends Field>)fields);
                        for (Field field : fields) {
                            Value value = ((JdiValueManager)valueManager).createValue(fieldToValue.get(field));
                            variables.add(new VariableImpl(field.name(), value, null));
                        }
                        this.updateCacheStamp();
                        this.promise.setResult(variables);
                    }
                });
                AsyncPromise asyncPromise = promise;
                if (asyncPromise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiObject$1", "load"));
                }
                return asyncPromise;
            }
        };
    }

    private static boolean shouldDisplay(@NotNull ClassRenderer classRenderer, @NotNull Field field) {
        if (classRenderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classRenderer", "com/jetbrains/debugger/jdi/JdiObject", "shouldDisplay"));
        }
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/jetbrains/debugger/jdi/JdiObject", "shouldDisplay"));
        }
        boolean isSynthetic = DebuggerUtils.isSynthetic((TypeComponent)field);
        if (!classRenderer.SHOW_SYNTHETICS && isSynthetic) {
            return false;
        }
        if (!classRenderer.SHOW_STATIC && field.isStatic()) {
            return false;
        }
        return classRenderer.SHOW_STATIC_FINAL || !field.isStatic() || !field.isFinal();
    }

    @Nullable
    public String getClassName() {
        return null;
    }

    @NotNull
    public ObjectReference getReference() {
        ObjectReference objectReference = this.objectReference;
        if (objectReference == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiObject", "getReference"));
        }
        return objectReference;
    }

    @NotNull
    public ThreeState hasProperties() {
        ThreeState threeState = this.getReference().referenceType().allFields().isEmpty() ? ThreeState.NO : ThreeState.YES;
        if (threeState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/debugger/jdi/JdiObject", "hasProperties"));
        }
        return threeState;
    }
}

