/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import org.jetbrains.annotations.NotNull;

public final class CompanionObjectMapping {
    private static final LinkedHashSet<FqName> classesFqNames;
    public static final CompanionObjectMapping INSTANCE;

    @NotNull
    public final Set<FqName> allClassesWithIntrinsicCompanions() {
        Set<FqName> set = Collections.unmodifiableSet((Set)classesFqNames);
        Intrinsics.checkExpressionValueIsNotNull(set, "Collections.unmodifiableSet(classesFqNames)");
        return set;
    }

    public final boolean isMappedIntrinsicCompanionObject(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        if (!DescriptorUtils.isCompanionObject(classDescriptor)) {
            return false;
        }
        FqNameUnsafe fqName2 = DescriptorUtils.getFqName(classDescriptor.getContainingDeclaration());
        if (!fqName2.isSafe()) {
            return false;
        }
        return classesFqNames.contains(fqName2.toSafe());
    }

    private CompanionObjectMapping() {
        INSTANCE = this;
        classesFqNames = SetsKt.linkedSetOf(new FqName[0]);
        for (PrimitiveType type2 : PrimitiveType.NUMBER_TYPES) {
            classesFqNames.add(KotlinBuiltIns.getPrimitiveFqName(type2));
        }
        classesFqNames.add(KotlinBuiltIns.FQ_NAMES.string.toSafe());
        classesFqNames.add(KotlinBuiltIns.FQ_NAMES._enum.toSafe());
    }

    static {
        new CompanionObjectMapping();
    }
}

