/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.lang.jsp.introduceParameter;

import com.intellij.lang.jspx.JSPXLanguage;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.lang.jsp.introduceParameter.JspIntroduceParameterDialog;
import com.intellij.refactoring.lang.jsp.introduceParameter.JspIntroduceParameterProcessor;
import com.intellij.refactoring.lang.jsp.introduceParameter.JspxIntroduceParameterProcessor;
import org.jetbrains.annotations.NotNull;

public class JspIntroduceParameterHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/lang/jsp/introduceParameter/JspIntroduceParameterHandler", "invoke"));
        }
        SelectionModel model = editor.getSelectionModel();
        String text = model.hasSelection() ? model.getSelectedText() : "";
        JspIntroduceParameterDialog dialog = new JspIntroduceParameterDialog((JspFile)file, editor, text, this);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            dialog.close(0);
            dialog.doAction();
        } else {
            dialog.show();
        }
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/lang/jsp/introduceParameter/JspIntroduceParameterHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/lang/jsp/introduceParameter/JspIntroduceParameterHandler", "invoke"));
        }
        throw new UnsupportedOperationException();
    }

    public JspIntroduceParameterProcessor createIntroduceParameterProcessor(JspFile tagFile, Editor editor, String parameterName, String selectedText) {
        boolean jspx = tagFile.getLanguage() == JSPXLanguage.INSTANCE;
        return jspx ? new JspxIntroduceParameterProcessor(tagFile, editor, parameterName, selectedText) : new JspIntroduceParameterProcessor(tagFile, editor, parameterName, selectedText);
    }

    public String getDialogTitle() {
        return "Introduce Tag Parameter";
    }
}

