/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.jsp;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.jsp.impl.JspTemplateType;
import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.jsp.NewJspLanguage;
import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer._JspDirectiveLexer;
import com.intellij.psi.impl.source.parsing.ParseUtilBase;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.tree.CustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.jsp.IJspElementType;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public interface BaseJspElementType
extends XmlElementType,
JspTokenType {
    public static final CustomParsingType JSP_DIRECTIVE = new CustomParsingType("JSP_DIRECTIVE", (Language)NewJspLanguage.INSTANCE){

        @NotNull
        public ASTNode parse(@NotNull CharSequence text, @NotNull CharTable table) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/jsp/BaseJspElementType$1", "parse"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/psi/jsp/BaseJspElementType$1", "parse"));
            }
            CompositeElement root = ASTFactory.composite((IElementType)this);
            FlexAdapter lexer = new FlexAdapter((FlexLexer)new _JspDirectiveLexer());
            lexer.start(text);
            this.parseDirective((Lexer)lexer, root, table);
            if (lexer.getTokenType() != null) {
                CompositeElement errorElement = this.addErrorElement(root, XmlErrorMessages.message((String)"jsp.unparseable.content", (Object[])new Object[0]));
                while (lexer.getTokenType() != null) {
                    this.addAndAdvance(errorElement, (Lexer)lexer, table);
                }
            }
            CompositeElement compositeElement = root;
            if (compositeElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/jsp/BaseJspElementType$1", "parse"));
            }
            return compositeElement;
        }

        private void parseDirective(Lexer lexer, CompositeElement treeElement, CharTable table) {
            if (lexer.getTokenType() != XmlTokenType.XML_START_TAG_START) {
                return;
            }
            this.addAndAdvance(treeElement, lexer, table);
            if (lexer.getTokenType() == XmlTokenType.XML_WHITE_SPACE) {
                this.addAndAdvance(treeElement, lexer, table);
            }
            if (lexer.getTokenType() != XmlTokenType.XML_NAME) {
                return;
            }
            this.addAndAdvance(treeElement, lexer, table);
            while (lexer.getTokenType() == XmlTokenType.XML_WHITE_SPACE || lexer.getTokenType() == XmlTokenType.XML_NAME) {
                if (lexer.getTokenType() == XmlTokenType.XML_WHITE_SPACE) {
                    this.addAndAdvance(treeElement, lexer, table);
                }
                if (lexer.getTokenType() != XmlTokenType.XML_NAME) continue;
                CompositeElement attribute = ASTFactory.composite((IElementType)XmlElementType.XML_ATTRIBUTE);
                treeElement.rawAddChildrenWithoutNotifications((TreeElement)attribute);
                this.parseAttribute(lexer, attribute, table);
            }
            if (lexer.getTokenType() != XmlTokenType.XML_EMPTY_ELEMENT_END) {
                if (lexer.getTokenType() == null) {
                    treeElement.rawAddChildrenWithoutNotifications((TreeElement)Factory.createErrorElement((String)XmlErrorMessages.message((String)"jsp.directive.end.expected", (Object[])new Object[0])));
                }
                return;
            }
            this.addAndAdvance(treeElement, lexer, table);
        }

        private void parseAttribute(Lexer lexer, CompositeElement attribute, CharTable table) {
            this.addAndAdvance(attribute, lexer, table);
            if (lexer.getTokenType() == XmlTokenType.XML_WHITE_SPACE) {
                this.addAndAdvance(attribute, lexer, table);
            }
            if (lexer.getTokenType() != XmlTokenType.XML_EQ) {
                this.addErrorElement(attribute, XmlErrorMessages.message((String)"expected.attribute.eq.sign", (Object[])new Object[0]));
                return;
            }
            this.addAndAdvance(attribute, lexer, table);
            if (lexer.getTokenType() == XmlTokenType.XML_WHITE_SPACE) {
                this.addAndAdvance(attribute, lexer, table);
            }
            if (lexer.getTokenType() != XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
                this.addErrorElement(attribute, XmlErrorMessages.message((String)"attribute.value.expected", (Object[])new Object[0]));
                return;
            }
            CompositeElement attributeValue = ASTFactory.composite((IElementType)XmlElementType.XML_ATTRIBUTE_VALUE);
            attribute.rawAddChildrenWithoutNotifications((TreeElement)attributeValue);
            this.addAndAdvance(attributeValue, lexer, table);
            if (lexer.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                this.addAndAdvance(attributeValue, lexer, table);
            }
            if (lexer.getTokenType() != XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
                this.addErrorElement(attributeValue, XmlErrorMessages.message((String)"quote.expected", (Object[])new Object[0]));
                return;
            }
            this.addAndAdvance(attributeValue, lexer, table);
        }

        private void addAndAdvance(CompositeElement attribute, Lexer lexer, CharTable table) {
            TreeElement token = ParseUtilBase.createTokenElement((Lexer)lexer, (CharTable)table);
            assert (token != null);
            attribute.rawAddChildrenWithoutNotifications(token);
            lexer.advance();
        }

        private CompositeElement addErrorElement(CompositeElement treeElement, String message) {
            CompositeElement errorElement = Factory.createErrorElement((String)message);
            treeElement.rawAddChildrenWithoutNotifications((TreeElement)errorElement);
            return errorElement;
        }
    };
    public static final CustomParsingType JSP_SCRIPTLET = new CustomParsingType("JSP_SCRIPTLET", (Language)NewJspLanguage.INSTANCE){

        @NotNull
        public ASTNode parse(@NotNull CharSequence text, @NotNull CharTable table) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/jsp/BaseJspElementType$2", "parse"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/psi/jsp/BaseJspElementType$2", "parse"));
            }
            ASTNode aSTNode = BaseJspUtil.parseSimpleJspBlock((IElementType)this, text, table, JspTokenType.JSP_SCRIPTLET_START, JspTokenType.JSP_SCRIPTLET_END, 2);
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/jsp/BaseJspElementType$2", "parse"));
            }
            return aSTNode;
        }
    };
    public static final CustomParsingType JSP_EXPRESSION = new CustomParsingType("JSP_EXPRESSION", (Language)NewJspLanguage.INSTANCE){

        @NotNull
        public ASTNode parse(@NotNull CharSequence text, @NotNull CharTable table) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/jsp/BaseJspElementType$3", "parse"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/psi/jsp/BaseJspElementType$3", "parse"));
            }
            ASTNode aSTNode = BaseJspUtil.parseSimpleJspBlock((IElementType)this, text, table, JspTokenType.JSP_EXPRESSION_START, JspTokenType.JSP_EXPRESSION_END, 3);
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/jsp/BaseJspElementType$3", "parse"));
            }
            return aSTNode;
        }
    };
    public static final CustomParsingType JSP_DECLARATION = new CustomParsingType("JSP_DECLARATION_NEW", (Language)NewJspLanguage.INSTANCE){

        @NotNull
        public ASTNode parse(@NotNull CharSequence text, @NotNull CharTable table) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/psi/jsp/BaseJspElementType$4", "parse"));
            }
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/psi/jsp/BaseJspElementType$4", "parse"));
            }
            ASTNode aSTNode = BaseJspUtil.parseSimpleJspBlock((IElementType)this, text, table, JspTokenType.JSP_DECLARATION_START, JspTokenType.JSP_DECLARATION_END, 3);
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/jsp/BaseJspElementType$4", "parse"));
            }
            return aSTNode;
        }
    };
    public static final IFileElementType JSP_TEMPLATE = new JspTemplateType();
    public static final IJspElementType JSP_DOCUMENT = new IJspElementType("JSP_DOCUMENT");
    public static final IJspElementType JSP_ROOT_TAG = new IJspElementType("JSP_ROOT_TAG");
    public static final IElementType JSP_XML_TEXT = new IJspElementType("JSP_XML_TEXT");
}

