/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.parsing.jsp;

import com.intellij.lang.jsp.JspFileViewProvider;
import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.impl.source.parsing.jsp.JspLexer2;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.tree.IElementType;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JspLexer
extends Lexer {
    private JspLexer2 myOriginal = null;
    private boolean myHighlightLexerFlag = false;
    private boolean mySpecialWhitespacesInTemplates = false;
    private BaseJspFile myBaseFile;
    private boolean myElIgnored;

    public JspLexer() {
        this.mySpecialWhitespacesInTemplates = true;
    }

    public JspLexer(boolean highlightLexerFlag) {
        this.myHighlightLexerFlag = highlightLexerFlag;
    }

    public void setFile(BaseJspFile base) {
        this.myBaseFile = base;
    }

    public void setElIgnored(boolean elIgnored) {
        this.myElIgnored = elIgnored;
    }

    public Position position() {
        int start = this.getTokenStart();
        int end = this.getTokenEnd();
        int state = this.getAfterState();
        return new Position(start, end, state, this.getTokenType());
    }

    public void restore(Position p) {
        this.myOriginal.restore(p.start, p.end, p.state, p.token);
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        JspxFileViewProvider provider;
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/psi/impl/source/parsing/jsp/JspLexer", "start"));
        }
        Set prefixes = this.myBaseFile != null && (provider = this.myBaseFile.getViewProvider()) instanceof JspFileViewProvider && !provider.getManager().getProject().isDisposed() ? ((JspFileViewProvider)provider).getXmlNsPrefixes(buffer) : Collections.singleton("xml");
        this.myOriginal = new JspLexer2(prefixes, this.myHighlightLexerFlag, this.mySpecialWhitespacesInTemplates);
        this.myOriginal.setElIgnored(this.myElIgnored);
        this.myOriginal.start(buffer, startOffset, endOffset, initialState);
    }

    public int getState() {
        return this.myOriginal.getState();
    }

    public int getAfterState() {
        return this.myOriginal.getAfterState();
    }

    public IElementType getTokenType() {
        return this.myOriginal.getTokenType();
    }

    public int getTokenStart() {
        return this.myOriginal.getTokenStart();
    }

    public int getTokenEnd() {
        return this.myOriginal.getTokenEnd();
    }

    public void advance() {
        this.myOriginal.advance();
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        LexerPosition lexerPosition = this.myOriginal.getCurrentPosition();
        if (lexerPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/parsing/jsp/JspLexer", "getCurrentPosition"));
        }
        return lexerPosition;
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/psi/impl/source/parsing/jsp/JspLexer", "restore"));
        }
        this.myOriginal.restore(position);
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myOriginal.getBufferSequence();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/parsing/jsp/JspLexer", "getBufferSequence"));
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myOriginal.getBufferEnd();
    }

    public static class Position {
        public int start;
        public int end;
        public int state;
        private final IElementType token;

        private Position(int start, int end, int state, IElementType token) {
            this.end = end;
            this.start = start;
            this.state = state;
            this.token = token;
        }
    }
}

