/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.jspJava;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.impl.source.jsp.JspImplUtil;
import com.intellij.psi.impl.source.jsp.JspImplicitVariableImpl;
import com.intellij.psi.impl.source.jsp.jspJava.JspClass;
import com.intellij.psi.impl.source.jsp.jspJava.JspClassImpl;
import com.intellij.psi.impl.source.jsp.jspJava.JspCodeBlock;
import com.intellij.psi.impl.source.jsp.jspJava.JspHolderMethod;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.jsp.JavaJspElementVisitor;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspElementType;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspImplicitVariable;
import com.intellij.psi.jsp.JspUtil;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.HashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JspHolderMethodImpl
extends CompositePsiElement
implements JspHolderMethod {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.jsp.jspJava.JspHolderMethod");
    private JspImplicitVariable[] myCachedPredefinedVariables;
    @NonNls
    private static final String JSP_SERVICE_METHOD_SYNTHETIC_NAME = "jsp_service_method";
    private PsiParameterList myParameterList;
    private TIntObjectHashMap<XmlTag> myOffsetToIncludeTag;

    public JspHolderMethodImpl() {
        super(JspElementType.HOLDER_METHOD);
    }

    public PsiFile getContainingFile() {
        PsiFile file = this.getJspClass().getContainingFile();
        if (file == null) {
            throw new PsiInvalidElementAccessException((PsiElement)this);
        }
        return file;
    }

    public TextRange getTextRange() {
        return this.getJspClass().getTextRange();
    }

    public PsiElement getParent() {
        return this.getJspClass();
    }

    public String toString() {
        return "Holder method for file " + this.getJspClass().getJspxFile().getName() + ".";
    }

    @NotNull
    public String getText() {
        String string = this.getContainingFile().getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "getText"));
        }
        return string;
    }

    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitMethod((PsiMethod)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public ASTNode copyElement() {
        return ((JspClassImpl)this.getJspClass().copy()).getHolderMethod();
    }

    public PsiType getReturnType() {
        return PsiType.VOID;
    }

    public PsiTypeElement getReturnTypeElement() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processDeclarations(final @NotNull PsiScopeProcessor processor, final @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "processDeclarations"));
        }
        if (!PsiImplUtil.processDeclarationsInMethod((PsiMethod)this, (PsiScopeProcessor)processor, (ResolveState)state, (PsiElement)lastParent, (PsiElement)place)) {
            return false;
        }
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (classHint == null || classHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            JspImplicitVariable[] predefinedVariables;
            for (JspImplicitVariable predefinedVariable : predefinedVariables = this.getPredefinedVariables()) {
                if (processor.execute((PsiElement)predefinedVariable, state)) continue;
                return false;
            }
        }
        class IncludesVisitor
        extends JavaJspElementVisitor {
            boolean stop = false;

            IncludesVisitor() {
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }

            public void visitJspFile(JspFile file) {
                PsiElement[] localDeclarations;
                if (this.stop) {
                    return;
                }
                JspCodeBlock jspCodeBlock = (JspCodeBlock)((JspClass)file.getJavaClass()).getHolderMethod().getBody();
                for (PsiElement localDeclaration : localDeclarations = jspCodeBlock.getLocalDeclarations()) {
                    boolean bl = this.stop = !processor.execute(localDeclaration, state);
                    if (this.stop) break;
                }
            }
        }
        IncludesVisitor visitor = new IncludesVisitor();
        HashSet set = new HashSet();
        final int offset = place.getTextRange().getStartOffset();
        JspHolderMethodImpl jspHolderMethodImpl = this;
        synchronized (jspHolderMethodImpl) {
            this.buildOffsetToIncludeTagMap();
            this.myOffsetToIncludeTag.forEachEntry((TIntObjectProcedure)new TIntObjectProcedure<XmlTag>((Set)set){
                final /* synthetic */ Set val$set;
                {
                    this.val$set = set;
                }

                public boolean execute(int tagOffset, XmlTag tag) {
                    if (tagOffset <= offset) {
                        this.val$set.add(tag);
                    }
                    return true;
                }
            });
        }
        JspUtil.visitAllIncludes(JspPsiUtil.getJspFile((PsiElement)this), (Set<XmlTag>)set, visitor);
        return !visitor.stop;
    }

    @NotNull
    public PsiParameterList getParameterList() {
        PsiParameterList psiParameterList;
        if (this.myParameterList != null) {
            PsiParameterList psiParameterList2 = this.myParameterList;
            if (psiParameterList2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "getParameterList"));
            }
            return psiParameterList2;
        }
        try {
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            psiParameterList = this.myParameterList = elementFactory.createParameterList(new String[]{"request", "response"}, new PsiType[]{elementFactory.createTypeByFQClassName("javax.servlet.http.HttpServletRequest", this.getResolveScope()), elementFactory.createTypeByFQClassName("javax.servlet.http.HttpServletResponse", this.getResolveScope())});
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "getParameterList"));
            }
            return null;
        }
        if (psiParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "getParameterList"));
        }
        return psiParameterList;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList;
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
        PsiJavaCodeReferenceElement ioException = elementFactory.createFQClassNameReferenceElement("java.io.IOException", this.getResolveScope());
        PsiJavaCodeReferenceElement servletException = elementFactory.createFQClassNameReferenceElement("javax.servlet.ServletException", this.getResolveScope());
        PsiJavaCodeReferenceElement[] references = new PsiJavaCodeReferenceElement[]{ioException, servletException};
        try {
            psiReferenceList = elementFactory.createReferenceList(references);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "getThrowsList"));
            }
            return null;
        }
        if (psiReferenceList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "getThrowsList"));
        }
        return psiReferenceList;
    }

    @NotNull
    public PsiCodeBlock getBody() {
        PsiCodeBlock psiCodeBlock = (PsiCodeBlock)this.getFirstChildNode().getPsi();
        if (psiCodeBlock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "getBody"));
        }
        return psiCodeBlock;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isVarArgs() {
        return false;
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "getSignature"));
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (methodSignatureBackedByPsiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "getSignature"));
        }
        return methodSignatureBackedByPsiMethod;
    }

    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "findSuperMethods"));
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "findSuperMethods"));
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "findSuperMethods"));
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List<MethodSignatureBackedByPsiMethod> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "findSuperMethodSignaturesIncludingStatic"));
        }
        return list;
    }

    public PsiMethod findDeepestSuperMethod() {
        return null;
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        if (PsiMethod.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "findDeepestSuperMethods"));
        }
        return PsiMethod.EMPTY_ARRAY;
    }

    public PsiClass getContainingClass() {
        return this.getJspClass();
    }

    @NotNull
    public PsiModifierList getModifierList() {
        LightModifierList lightModifierList = new LightModifierList((PsiManager)this.getManager());
        if (lightModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "getModifierList"));
        }
        return lightModifierList;
    }

    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "hasModifierProperty"));
        }
        return false;
    }

    @NotNull
    public String getName() {
        if (JSP_SERVICE_METHOD_SYNTHETIC_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "getName"));
        }
        return JSP_SERVICE_METHOD_SYNTHETIC_NAME;
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature((PsiMethod)this);
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "getHierarchicalMethodSignature"));
        }
        return hierarchicalMethodSignature;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "setName"));
        }
        throw new IncorrectOperationException("Can't change name of JSP service method");
    }

    public PsiDocComment getDocComment() {
        return null;
    }

    public boolean isDeprecated() {
        return false;
    }

    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    public boolean hasTypeParameters() {
        return false;
    }

    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        if (PsiTypeParameter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "getTypeParameters"));
        }
        return PsiTypeParameter.EMPTY_ARRAY;
    }

    private JspImplicitVariable[] getPredefinedVariables() {
        if (this.myCachedPredefinedVariables == null) {
            ArrayList<JspImplicitVariable> vars = new ArrayList<JspImplicitVariable>();
            vars.add(new JspImplicitVariableImpl((PsiElement)this, "jspContext", "javax.servlet.jsp.JspContext", null));
            vars.add(new JspImplicitVariableImpl((PsiElement)this, "application", "javax.servlet.ServletContext", null));
            vars.add(new JspImplicitVariableImpl((PsiElement)this, "out", "javax.servlet.jsp.JspWriter", null));
            vars.add(new JspImplicitVariableImpl((PsiElement)this, "config", "javax.servlet.ServletConfig", null));
            vars.add(new JspImplicitVariableImpl((PsiElement)this, "page", "java.lang.Object", null));
            JspFile jspxFile = this.getJspClass().getJspxFile();
            if (jspxFile.isErrorPage()) {
                vars.add(new JspImplicitVariableImpl((PsiElement)this, "exception", "java.lang.Throwable", null));
            }
            if (jspxFile.isSessionPage()) {
                vars.add(new JspImplicitVariableImpl((PsiElement)this, "session", "javax.servlet.http.HttpSession", null));
            }
            JspImplUtil.addSharedImplicitVars((PsiElement)this, jspxFile, vars);
            this.myCachedPredefinedVariables = vars.toArray(new JspImplicitVariable[vars.size()]);
        }
        return this.myCachedPredefinedVariables;
    }

    public synchronized void clearCaches() {
        super.clearCaches();
        this.myCachedPredefinedVariables = null;
        this.myParameterList = null;
        this.myOffsetToIncludeTag = null;
    }

    private void buildOffsetToIncludeTagMap() {
        if (this.myOffsetToIncludeTag == null) {
            this.myOffsetToIncludeTag = new TIntObjectHashMap();
            JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)this);
            if (jspFile != null) {
                XmlTag[] includeTags;
                for (XmlTag includeTag : includeTags = jspFile.getDirectiveTags(JspDirectiveKind.INCLUDE, false)) {
                    this.myOffsetToIncludeTag.put(includeTag.getTextRange().getStartOffset(), (Object)includeTag);
                }
            }
        }
    }

    public boolean isWritable() {
        return false;
    }

    public JspClass getJspClass() {
        PsiFile psiFile = (PsiFile)TreeUtil.getFileElement((TreeElement)this).getPsi();
        FileViewProvider viewProvider = psiFile.getViewProvider();
        PsiJavaFile javaRoot = (PsiJavaFile)viewProvider.getPsi((Language)JavaLanguage.INSTANCE);
        if (javaRoot == null) {
            return null;
        }
        return (JspClass)javaRoot.getClasses()[0];
    }

    @NotNull
    public Language getLanguage() {
        JavaLanguage javaLanguage = JavaLanguage.INSTANCE;
        if (javaLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "getLanguage"));
        }
        return javaLanguage;
    }

    public Icon getElementIcon(int flags) {
        Icon methodIcon = this.hasModifierProperty("abstract") ? PlatformIcons.ABSTRACT_METHOD_ICON : PlatformIcons.METHOD_ICON;
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon((Icon)methodIcon, (PsiModifierListOwner)this, (boolean)false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, (int)flags, (RowIcon)baseIcon);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo((PsiMethod)this, (PsiElement)another);
    }

    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = PsiImplUtil.getMemberUseScope((PsiMember)this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspHolderMethodImpl", "getUseScope"));
        }
        return searchScope;
    }

    public PsiElement getContext() {
        PsiClass cc = this.getContainingClass();
        return cc != null ? cc : super.getContext();
    }
}

