/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.jsp.TaglibIndex;
import com.intellij.psi.impl.source.jsp.WebTldProvider;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.FactoryMap;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.index.IndexedRelevantResource;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TldProvider {
    @NonNls
    public static final String TAGS_DIR = "/WEB-INF/tags";
    public static final TldProvider DEFAULT = new TldProvider(){

        @Override
        public XmlFile getTldFileByUri(String uri, @NotNull Module module, @Nullable JspFile context) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/impl/source/jsp/TldProvider$1", "getTldFileByUri"));
            }
            List<IndexedRelevantResource<String, TaglibIndex.TaglibInfo>> resources = TaglibIndex.getTldFiles(uri, module, context);
            if (resources.isEmpty()) {
                return null;
            }
            IndexedRelevantResource<String, TaglibIndex.TaglibInfo> max = Collections.max(resources);
            PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
            PsiFile file = psiManager.findFile(max.getFile());
            return file instanceof XmlFile ? (XmlFile)file : null;
        }

        @Override
        public void collectUris(@NotNull Module module, FactoryMap<String, XmlFile> map, JspFile context) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/impl/source/jsp/TldProvider$1", "collectUris"));
            }
            List<IndexedRelevantResource<String, TaglibIndex.TaglibInfo>> resources = TaglibIndex.getTldFiles(module, context);
            for (IndexedRelevantResource<String, TaglibIndex.TaglibInfo> resource : resources) {
                String key;
                PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
                PsiFile psiFile = psiManager.findFile(resource.getFile());
                if (!(psiFile instanceof XmlFile) || map.containsKey((Object)(key = (String)resource.getKey()))) continue;
                map.put((Object)key, (Object)((XmlFile)psiFile));
            }
        }
    };
    public static final TldProvider LOCAL = new TldProvider(){

        @Override
        public XmlFile getTldFileByUri(String uri, @NotNull Module module, @Nullable JspFile context) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/impl/source/jsp/TldProvider$2", "getTldFileByUri"));
            }
            if (context == null) {
                return null;
            }
            WebFacet webFacet = WebUtil.getWebFacet((PsiElement)context);
            if (webFacet == null) {
                return null;
            }
            return WebTldProvider.resolveResource(uri, webFacet);
        }

        @Override
        public void collectUris(@NotNull Module module, FactoryMap<String, XmlFile> map, JspFile context) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/impl/source/jsp/TldProvider$2", "collectUris"));
            }
        }
    };
    public static final TldProvider WEB = new WebTldProvider();
    public static final TldProvider MAPPED = new TldProvider(){

        @Override
        public XmlFile getTldFileByUri(String uri, @NotNull Module module, @Nullable JspFile context) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/impl/source/jsp/TldProvider$3", "getTldFileByUri"));
            }
            String location = ExternalResourceManagerEx.getInstanceEx().getUserResource(module.getProject(), uri, null);
            if (location != null) {
                return this.findXmlFile(module, location);
            }
            return null;
        }

        @Override
        public void collectUris(@NotNull Module module, FactoryMap<String, XmlFile> map, JspFile context) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/impl/source/jsp/TldProvider$3", "collectUris"));
            }
            ExternalResourceManager resourceManager = ExternalResourceManager.getInstance();
            for (String url : resourceManager.getResourceUrls(null, false)) {
                XmlFile xmlFile;
                String location = resourceManager.getResourceLocation(url, module.getProject());
                if (location == null || (xmlFile = this.findXmlFile(module, location)) == null || map.containsKey((Object)url)) continue;
                map.put((Object)url, (Object)xmlFile);
            }
        }

        @Nullable
        private XmlFile findXmlFile(Module module, String location) {
            XmlDocument document;
            PsiFile psiFile;
            if (!location.endsWith(".tld") && !location.endsWith(".xml")) {
                return null;
            }
            VirtualFile virtualFile = VfsUtilCore.findRelativeFile((String)location, null);
            if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile)) instanceof XmlFile && (document = ((XmlFile)psiFile).getDocument()) != null && document.getMetaData() instanceof XmlNSDescriptor) {
                return (XmlFile)psiFile;
            }
            return null;
        }
    };
    public static final TldProvider[] ALL = new TldProvider[]{MAPPED, DEFAULT, LOCAL, WEB};

    @Nullable
    public XmlFile getTldFileByUri(String var1, @NotNull Module var2, @Nullable JspFile var3);

    public void collectUris(@NotNull Module var1, FactoryMap<String, XmlFile> var2, @Nullable JspFile var3);
}

