/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.impl.artifacts.ArtifactBySourceFileFinder;
import com.intellij.psi.impl.source.jsp.TaglibUriXmlBuilder;
import com.intellij.psi.impl.source.jsp.TldProcessorFactory;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.XmlIndex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaglibIndex
extends XmlIndex<TaglibInfo> {
    @NonNls
    private static final MultiMap<String, String> WRAPPED_FACELETS_TAGLIBS = new MultiMap();
    public static final ID<String, TaglibInfo> NAME;

    public static List<IndexedRelevantResource<String, TaglibInfo>> getTldFiles(String namespace, @NotNull Module module, @Nullable JspFile context) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/impl/source/jsp/TaglibIndex", "getTldFiles"));
        }
        GlobalSearchScope scope = TaglibIndex.computeAdditionalScope(module, context);
        List resources = IndexedRelevantResource.getResources(NAME, (Object)namespace, (Module)module, (Project)module.getProject(), (GlobalSearchScope)scope);
        Collections.sort(resources);
        TldProcessorFactory.getFactory(context).processResources(resources);
        return resources;
    }

    @Nullable
    private static GlobalSearchScope computeAdditionalScope(Module module, @Nullable JspFile context) {
        if (context == null) {
            return null;
        }
        VirtualFile file = context.getVirtualFile();
        if (file == null) {
            return null;
        }
        final ArtifactBySourceFileFinder finder = ArtifactBySourceFileFinder.getInstance((Project)module.getProject());
        final Collection artifacts = finder.findArtifacts(file);
        if (artifacts.isEmpty()) {
            return null;
        }
        return new GlobalSearchScope(){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/TaglibIndex$1", "contains"));
                }
                Collection a = finder.findArtifacts(file);
                return ContainerUtil.intersects((Collection)artifacts, (Collection)a);
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/psi/impl/source/jsp/TaglibIndex$1", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/psi/impl/source/jsp/TaglibIndex$1", "compare"));
                }
                return 0;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/psi/impl/source/jsp/TaglibIndex$1", "isSearchInModuleContent"));
                }
                return true;
            }

            public boolean isSearchInLibraries() {
                return false;
            }
        };
    }

    public static List<IndexedRelevantResource<String, TaglibInfo>> getTldFiles(Module module, JspFile context) {
        return IndexedRelevantResource.getAllResources(NAME, (Module)module, (Project)module.getProject(), resources -> {
            TldProcessorFactory.getFactory(context).processResources((List<IndexedRelevantResource<String, TaglibInfo>>)resources);
            return resources.isEmpty() ? null : (IndexedRelevantResource)Collections.max(resources);
        });
    }

    @NotNull
    public ID<String, TaglibInfo> getName() {
        ID<String, TaglibInfo> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/TaglibIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{XmlFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/TaglibIndex$2", "acceptInput"));
                }
                String name = file.getName();
                return name.endsWith(".tld") || name.endsWith(".taglib.xml") || name.endsWith(".xml") && file.isInLocalFileSystem();
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/TaglibIndex", "getInputFilter"));
        }
        return defaultFileTypeSpecificInputFilter;
    }

    @NotNull
    public DataIndexer<String, TaglibInfo, FileContent> getIndexer() {
        DataIndexer<String, TaglibInfo, FileContent> dataIndexer = new DataIndexer<String, TaglibInfo, FileContent>(){

            @NotNull
            public Map<String, TaglibInfo> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/psi/impl/source/jsp/TaglibIndex$3", "map"));
                }
                TaglibUriXmlBuilder builder = new TaglibUriXmlBuilder();
                NanoXmlUtil.parse((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()), (IXMLBuilder)builder);
                if (builder.isUriFound()) {
                    String uri = builder.getUri();
                    Collection realUris = WRAPPED_FACELETS_TAGLIBS.get((Object)uri);
                    if (realUris.isEmpty()) {
                        Map<String, TaglibInfo> map = Collections.singletonMap(uri, new TaglibInfo(builder.getShortName(), null, builder.getVersion()));
                        if (map == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/TaglibIndex$3", "map"));
                        }
                        return map;
                    }
                }
                Map<String, TaglibInfo> map = Collections.emptyMap();
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/TaglibIndex$3", "map"));
                }
                return map;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/TaglibIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public DataExternalizer<TaglibInfo> getValueExternalizer() {
        DataExternalizer<TaglibInfo> dataExternalizer = new DataExternalizer<TaglibInfo>(){

            public void save(@NotNull DataOutput out, TaglibInfo value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/psi/impl/source/jsp/TaglibIndex$4", "save"));
                }
                out.writeUTF(value.shortName);
                out.writeUTF(value.wrappingClass);
                out.writeUTF(value.version);
            }

            public TaglibInfo read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/psi/impl/source/jsp/TaglibIndex$4", "read"));
                }
                return new TaglibInfo(in.readUTF(), in.readUTF(), in.readUTF());
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/TaglibIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    public int getVersion() {
        return 7;
    }

    public static boolean isFaceletsTaglib(VirtualFile file) {
        return file.getName().endsWith(".xml");
    }

    static {
        WRAPPED_FACELETS_TAGLIBS.put((Object)"com.sun.facelets.tag.jstl.core.JstlCoreLibrary", Arrays.asList("http://java.sun.com/jstl/core", "http://java.sun.com/jsp/jstl/core"));
        WRAPPED_FACELETS_TAGLIBS.put((Object)"com.sun.facelets.tag.jstl.fn.JstlFnLibrary", Arrays.asList("http://java.sun.com/jstl/functions", "http://java.sun.com/jsp/jstl/functions"));
        WRAPPED_FACELETS_TAGLIBS.putValue((Object)"com.sun.facelets.tag.ui.UILibrary", (Object)"http://java.sun.com/jsf/facelets");
        WRAPPED_FACELETS_TAGLIBS.putValue((Object)"com.sun.facelets.tag.jsf.html.HtmlLibrary", (Object)"http://java.sun.com/jsf/html");
        WRAPPED_FACELETS_TAGLIBS.putValue((Object)"com.sun.facelets.tag.jsf.core.CoreLibrary", (Object)"http://java.sun.com/jsf/core");
        NAME = ID.create((String)"taglibUris");
    }

    public static class TaglibInfo
    implements Comparable<TaglibInfo> {
        private final String shortName;
        private final String wrappingClass;
        private final String version;

        private TaglibInfo(String shortName, String wrappingClass, String version) {
            this.version = version == null ? "" : version;
            this.wrappingClass = wrappingClass == null ? "" : wrappingClass;
            this.shortName = shortName == null ? "" : shortName;
        }

        public String getShortName() {
            return this.shortName;
        }

        public String getWrappingClass() {
            return this.wrappingClass;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TaglibInfo that = (TaglibInfo)o;
            if (!this.shortName.equals(that.shortName)) {
                return false;
            }
            if (!this.wrappingClass.equals(that.wrappingClass)) {
                return false;
            }
            return this.version.equals(that.version);
        }

        public int hashCode() {
            int result = this.shortName.hashCode();
            result = 31 * result + this.wrappingClass.hashCode();
            result = 31 * result + this.version.hashCode();
            return result;
        }

        @Override
        public int compareTo(@NotNull TaglibInfo o) {
            if (o == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/psi/impl/source/jsp/TaglibIndex$TaglibInfo", "compareTo"));
            }
            return this.version.compareTo(o.getVersion());
        }
    }
}

