/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.jsp.impl.JspElementDescriptorEx;
import com.intellij.jsp.impl.JspNsDescriptor;
import com.intellij.jsp.impl.TldAttributeDescriptor;
import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.html.dtd.HtmlNSDescriptorImpl;
import com.intellij.psi.impl.source.jsp.JspFileIndex;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.impl.source.jsp.JspTagNameReference;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlRootTag;
import com.intellij.psi.impl.source.jsp.jspXml.JspXmlTagBase;
import com.intellij.psi.impl.source.xml.SchemaPrefix;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.el.ELExpressionHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.MultiMap;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlExtension;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JspXmlExtension
extends XmlExtension {
    @NonNls
    private static final String IMPORT_ATTRIBUTE = "import";

    public boolean isAvailable(PsiFile file) {
        return file.getViewProvider() instanceof JspxFileViewProvider;
    }

    @NotNull
    public List<XmlExtension.TagInfo> getAvailableTagNames(@NotNull XmlFile file, @NotNull XmlTag context) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspXmlExtension", "getAvailableTagNames"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/jsp/JspXmlExtension", "getAvailableTagNames"));
        }
        MultiMap names = JspManager.getInstance((Project)file.getProject()).getAvailableTagNames(JspPsiUtil.getJspFile((PsiElement)file));
        ArrayList<XmlExtension.TagInfo> list = new ArrayList<XmlExtension.TagInfo>(names.size());
        for (String tagName : names.keySet()) {
            Collection namespaces = names.get((Object)tagName);
            for (String namespace : namespaces) {
                list.add(new XmlExtension.TagInfo(tagName, namespace));
            }
        }
        if (!StringUtil.isEmpty((String)context.getNamespace())) {
            list.addAll(DefaultXmlExtension.DEFAULT_EXTENSION.getAvailableTagNames(file, context));
        }
        ArrayList<XmlExtension.TagInfo> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspXmlExtension", "getAvailableTagNames"));
        }
        return arrayList;
    }

    public String[][] getNamespacesFromDocument(XmlDocument parent, boolean declarationsExist) {
        return XmlUtil.getDefaultNamespaces((XmlDocument)parent);
    }

    public boolean canBeDuplicated(XmlAttribute attribute) {
        return attribute.getParent() instanceof JspDirective && attribute.getName().equals(IMPORT_ATTRIBUTE);
    }

    public boolean isRequiredAttributeImplicitlyPresent(XmlTag tag, String attrName) {
        XmlElementDescriptor descriptor = tag.getDescriptor();
        return descriptor instanceof JspElementDescriptorEx && ((JspElementDescriptorEx)descriptor).isRequiredAttributeImplicitlyPresent(tag, attrName);
    }

    public HighlightInfoType getHighlightInfoType(XmlFile file) {
        return file.getFileType() == StdFileTypes.JSPX ? HighlightInfoType.ERROR : HighlightInfoType.WARNING;
    }

    public SchemaPrefix getPrefixDeclaration(XmlTag context, String namespacePrefix) {
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)context);
        if (jspFile != null && jspFile.getFileType() == StdFileTypes.JSP) {
            XmlTag[] directiveTags;
            for (XmlTag t : directiveTags = jspFile.getDirectiveTags(JspDirectiveKind.TAGLIB, true)) {
                XmlAttribute attribute = t.getAttribute("prefix");
                if (attribute == null || !namespacePrefix.equals(attribute.getValue())) continue;
                return SchemaPrefix.createJspPrefix((XmlAttributeValue)attribute.getValueElement(), (String)namespacePrefix);
            }
            return null;
        }
        return DefaultXmlExtension.DEFAULT_EXTENSION.getPrefixDeclaration(context, namespacePrefix);
    }

    public SearchScope getNsPrefixScope(XmlAttribute declaration) {
        Project project = declaration.getProject();
        JspFileIndex index = JspFileIndex.getInstance(project);
        PsiFile psiFile = declaration.getContainingFile();
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null || index.isIncluded(file) || index.isIncludingAnything(file)) {
            return GlobalSearchScope.allScope((Project)project);
        }
        return new LocalSearchScope((PsiElement)((XmlFile)psiFile).getDocument());
    }

    public boolean shouldBeHighlightedAsTag(XmlTag tag) {
        return !(tag instanceof JspXmlTagBase) && !(tag instanceof JspXmlRootTag);
    }

    public XmlElementDescriptor getElementDescriptor(XmlTag tag, XmlTag contextTag, XmlElementDescriptor parentDescriptor) {
        if (tag instanceof JspDirective) {
            return tag.getDescriptor();
        }
        return super.getElementDescriptor(tag, contextTag, parentDescriptor);
    }

    public XmlNSDescriptor getNSDescriptor(XmlTag element, String namespace, boolean strict) {
        XmlNSDescriptor nsDescriptor = super.getNSDescriptor(element, namespace, strict);
        if (nsDescriptor == null && JspPsiUtil.isInJspFile((PsiElement)element)) {
            return JspPsiUtil.getJspFile((PsiElement)element).getRootTag().getNSDescriptor(namespace, strict);
        }
        return nsDescriptor;
    }

    public XmlTag getParentTagForNamespace(XmlTag element, XmlNSDescriptor namespace) {
        JspxFileViewProvider viewProvider;
        PsiElement psiElement;
        XmlTag xmlTag;
        JspFile file;
        if (namespace instanceof JspNsDescriptor && (file = JspPsiUtil.getJspFile((PsiElement)element)) != null && file.getFileType() == StdFileTypes.JSP && (xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)(psiElement = (viewProvider = file.getViewProvider()).findElementAt(element.getTextOffset(), viewProvider.getBaseLanguage())), XmlTag.class, (boolean)true)) != null && !xmlTag.equals(element)) {
            return xmlTag;
        }
        return super.getParentTagForNamespace(element, namespace);
    }

    public TagNameReference createTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        return new JspTagNameReference(nameElement, startTagFlag);
    }

    public XmlFile getContainingFile(PsiElement element) {
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)element);
        return jspFile == null ? super.getContainingFile(element) : jspFile;
    }

    public XmlNSDescriptor getDescriptorFromDoctype(XmlFile containingFile, XmlNSDescriptor descr) {
        XmlTag rootTag = containingFile.getRootTag();
        assert (rootTag != null);
        if (containingFile instanceof JspFile || this.isFaceletPrefix(rootTag)) {
            return new HtmlNSDescriptorImpl(descr, true, containingFile.getFileType() == StdFileTypes.JSP);
        }
        return descr;
    }

    private boolean isFaceletPrefix(@NotNull XmlTag rootTag) {
        if (rootTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTag", "com/intellij/psi/impl/source/jsp/JspXmlExtension", "isFaceletPrefix"));
        }
        for (String uri : XmlUtil.FACELETS_URIS) {
            if (rootTag.getPrefixByNamespace(uri) == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasDynamicComponents(PsiElement element) {
        return PsiTreeUtil.getChildOfAnyType((PsiElement)element, (Class[])new Class[]{JspXmlTagBase.class, ELExpressionHolder.class}) != null;
    }

    public boolean isIndirectSyntax(XmlAttributeDescriptor descriptor) {
        return descriptor instanceof TldAttributeDescriptor && ((TldAttributeDescriptor)descriptor).isIndirectSyntax();
    }

    public boolean isCustomTagAllowed(XmlTag tag) {
        return tag.getNSDescriptor(tag.getNamespace(), true) instanceof TldDescriptor;
    }
}

