/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.jsp.impl.CustomTagSupportUtil;
import com.intellij.jsp.impl.FunctionDescriptor;
import com.intellij.jsp.impl.JspElementDescriptor;
import com.intellij.jsp.impl.TldAttributeDescriptor;
import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.jsp.impl.TldTagDescriptor;
import com.intellij.jsp.impl.TldTagFileDescriptor;
import com.intellij.lang.documentation.DocumentationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.jsp.el.ELLanguage;
import com.intellij.psi.jsp.BaseJspUtil;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.el.ELFunctionCallExpression;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlStringUtil;
import com.intellij.xml.util.documentation.XHtmlDocumentationProvider;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class JspXmlDocumentationProvider
extends XHtmlDocumentationProvider {
    @NonNls
    private static final String REQUIRED_ATT = "required";
    @NonNls
    private static final String RTEXPRVALUE_ATT = "rtexprvalue";
    @NonNls
    private static final String TYPE_ATT = "type";
    @NonNls
    private static final String FRAGMENT_ATT = "fragment";
    @NonNls
    private static final String NAME_ATT = "name";
    @NonNls
    private static final String TAG_NAME_ATT = "tag-name";
    @NonNls
    private static final String DESCRIPTION_ATT = "description";
    @NonNls
    private static final String INFO_ATT = "info";
    @NonNls
    private static final String EXAMPLE_ATT = "example";
    @NonNls
    private static final String DISPLAY_NAME_ATT = "display-name";
    @NonNls
    private static final String TAGLIB_TAG = "taglib";

    public String generateDoc(PsiElement element, PsiElement context) {
        String descriptionChildTagText;
        XmlElementDescriptor descriptor;
        String xmlDocumentation;
        XmlElementDescriptor descriptor2;
        if (context != null && BaseJspUtil.getJspFile(context) == null) {
            return null;
        }
        if (element instanceof JspFile && context instanceof XmlToken && context.getParent() instanceof XmlTag && (descriptor2 = ((XmlTag)context.getParent()).getDescriptor()) instanceof TldTagFileDescriptor) {
            XmlTag[] tags;
            for (XmlTag tag : tags = ((JspFile)element).getDirectiveTagsInContext(JspDirectiveKind.PAGE)) {
                String description = tag.getAttributeValue(DESCRIPTION_ATT);
                if (description == null) continue;
                return description;
            }
            return "No description provided for tag file";
        }
        boolean isJsp = false;
        if (element instanceof XmlTag) {
            XmlTag xmlTag = (XmlTag)element;
            PsiMetaData metaData = xmlTag.getMetaData();
            isJsp = metaData instanceof TldAttributeDescriptor || metaData instanceof TldDescriptor || metaData instanceof TldTagDescriptor;
        } else if (element instanceof XmlAttributeValue) {
            isJsp = ((XmlAttribute)element.getParent()).getDescriptor() instanceof TldAttributeDescriptor;
        } else if (element instanceof XmlAttribute) {
            isJsp = ((XmlAttribute)element).getDescriptor() instanceof TldAttributeDescriptor;
        }
        if (!isJsp && (xmlDocumentation = super.generateDoc(element, context)) != null) {
            return xmlDocumentation;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)context, XmlTag.class, (boolean)false);
        if (tag != null && (descriptor = tag.getDescriptor()) instanceof JspElementDescriptor) {
            String descriptionChildTagText2;
            XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)context, XmlAttribute.class, (boolean)false);
            XmlTag declaration = null;
            if (this.isAttributeContext(context) || attribute != null) {
                XmlAttributeDescriptor attrDescriptor;
                if (element instanceof XmlTag) {
                    declaration = (XmlTag)element;
                } else if (attribute != null && (attrDescriptor = attribute.getDescriptor()) != null) {
                    declaration = (XmlTag)attrDescriptor.getDeclaration();
                }
                descriptionChildTagText2 = JspXmlDocumentationProvider.getDescriptionTextFromChildTagForAttribute(declaration);
            } else {
                if (element instanceof XmlTag) {
                    declaration = (XmlTag)element;
                } else {
                    PsiElement psiElement = descriptor.getDeclaration();
                    if (psiElement instanceof XmlTag) {
                        declaration = (XmlTag)psiElement;
                    }
                }
                if (descriptor instanceof TldTagFileDescriptor) {
                    declaration = ((TldTagFileDescriptor)descriptor).getRealDeclaration();
                }
                descriptionChildTagText2 = JspXmlDocumentationProvider.getDescriptionTextFromChildTag(declaration);
            }
            if (descriptionChildTagText2 != null) {
                return descriptionChildTagText2;
            }
        }
        if (element instanceof XmlTag && (descriptionChildTagText = JspXmlDocumentationProvider.getDescriptionTextFromChildTag((XmlTag)element)) != null) {
            return descriptionChildTagText;
        }
        return null;
    }

    @Nullable
    private static String getDescriptionTextFromChildTagForAttribute(XmlTag xmlTag) {
        String result;
        String fragment;
        String type;
        String rtexpr;
        if (xmlTag == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        CustomTagSupportUtil.ValueAccessor valueAccessor = JspXmlDocumentationProvider.getValueGetter(xmlTag);
        JspXmlDocumentationProvider.getDescriptionTextFromChildTag(xmlTag, buf, false, valueAccessor);
        buf.append("<br>");
        String required = valueAccessor.getValue(xmlTag, REQUIRED_ATT);
        if (required != null) {
            buf.append(PsiBundle.message((String)"jsp.documentation.message.required", (Object[])new Object[]{required})).append("<br>");
        }
        if ((rtexpr = valueAccessor.getValue(xmlTag, RTEXPRVALUE_ATT)) != null) {
            buf.append(PsiBundle.message((String)"jsp.documentation.message.can.have.runtime.value", (Object[])new Object[]{rtexpr})).append("<br>");
        }
        if ((type = valueAccessor.getValue(xmlTag, TYPE_ATT)) != null) {
            buf.append(PsiBundle.message((String)"jsp.documentation.message.type", (Object[])new Object[]{type})).append("<br>");
        }
        if ((fragment = valueAccessor.getValue(xmlTag, FRAGMENT_ATT)) != null) {
            buf.append(PsiBundle.message((String)"jsp.documentation.message.fragment", (Object[])new Object[]{fragment})).append("<br>");
        }
        return "<br>".equals(result = buf.toString()) ? null : result;
    }

    @Nullable
    private static String getDescriptionTextFromChildTag(XmlTag element) {
        if (element == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        JspXmlDocumentationProvider.getDescriptionTextFromChildTag(element, buf, !"attribute".equals(element.getName()), JspXmlDocumentationProvider.getValueGetter(element));
        if (buf.length() == 0) {
            return null;
        }
        return buf.toString();
    }

    private static CustomTagSupportUtil.ValueAccessor getValueGetter(XmlTag tag) {
        return tag.findFirstSubTag(NAME_ATT) != null || tag.findFirstSubTag(TAG_NAME_ATT) != null || tag.getName().equals(TAGLIB_TAG) ? CustomTagSupportUtil.ValueAccessor.SUB_TAG_ACCESSOR : CustomTagSupportUtil.ValueAccessor.ATTRIBUTE_ACCESSOR;
    }

    private static void getDescriptionTextFromChildTag(XmlTag element, StringBuilder buf, boolean tag, CustomTagSupportUtil.ValueAccessor accessor) {
        String name = accessor.getValue(element, NAME_ATT);
        if (name == null) {
            name = accessor.getValue(element, TAG_NAME_ATT);
        }
        if (name == null) {
            name = accessor.getValue(element, DISPLAY_NAME_ATT);
        }
        String type_message_id = tag ? (accessor.getValue(element, "function-class") != null ? "jsp.documentation.message.custom.function.name" : "jsp.documentation.message.custom.tag.name") : "jsp.documentation.message.custom.attribute.name";
        DocumentationUtil.formatEntityName((String)PsiBundle.message((String)type_message_id, (Object[])new Object[0]), (String)name, (StringBuilder)buf);
        String description = accessor.getValue(element, DESCRIPTION_ATT);
        if (description == null) {
            description = accessor.getValue(element, INFO_ATT);
        }
        if (description != null) {
            buf.append(PsiBundle.message((String)"jsp.documentation.message.description", (Object[])new Object[]{description}));
            String example = accessor.getValue(element, EXAMPLE_ATT);
            if (example != null) {
                buf.append("<br>").append(PsiBundle.message((String)"jsp.documentation.message.example.of.use", (Object[])new Object[]{XmlStringUtil.escapeString((String)example)}));
            }
        } else {
            buf.setLength(0);
        }
    }

    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        VirtualFile fileForJar;
        List urlFromSuper = super.getUrlFor(element, originalElement);
        if (urlFromSuper != null) {
            return urlFromSuper;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class);
        if (tag == null) {
            return null;
        }
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        if (!BaseJspUtil.isInJspFile(originalElement.getContainingFile())) {
            return null;
        }
        VirtualFile file = psiFile.getVirtualFile();
        VirtualFile virtualFile = fileForJar = file != null ? JarFileSystem.getInstance().getVirtualFileForJar(file) : null;
        if (fileForJar != null) {
            fileForJar = JarFileSystem.getInstance().getJarRootForLocalFile(fileForJar);
            for (Module module : ModuleManager.getInstance((Project)element.getProject()).getModules()) {
                for (OrderEntry entry : ModuleRootManager.getInstance((Module)module).getOrderEntries()) {
                    for (VirtualFile clazzFile : entry.getFiles(OrderRootType.CLASSES)) {
                        if (!Comparing.equal((Object)clazzFile, (Object)fileForJar)) continue;
                        for (String docRootUrl : JavadocOrderRootType.getUrls((OrderEntry)entry)) {
                            String dirName = tag.getNamespacePrefix();
                            String fileName = tag.getLocalName() + ".html";
                            VirtualFile virtualFile2 = VirtualFileManager.getInstance().findFileByUrl(docRootUrl + "/" + dirName + "/" + fileName);
                            if (virtualFile2 == null) continue;
                            return Collections.singletonList(virtualFile2.getUrl());
                        }
                    }
                }
            }
        }
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        XmlTag action = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        if (action != null && object instanceof XmlTag) {
            return (XmlTag)object;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class, (boolean)false);
        if (tag != null) {
            XmlAttributeDescriptor attributeDescriptor;
            if (element.getLanguage() == ELLanguage.INSTANCE) {
                String localName;
                FunctionDescriptor functionDescriptor;
                ELVariable namespace;
                String nsPrefix;
                String ns;
                XmlNSDescriptor nsDescriptor;
                ELFunctionCallExpression funcCall = (ELFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, ELFunctionCallExpression.class);
                if (funcCall != null && (nsDescriptor = tag.getNSDescriptor(ns = tag.getNamespaceByPrefix(nsPrefix = (namespace = funcCall.getNamespace()).getText()), true)) instanceof TldDescriptor && object instanceof String && (functionDescriptor = ((TldDescriptor)nsDescriptor).getFunctionDescriptor(localName = (String)object)) != null) {
                    return functionDescriptor.getTag();
                }
                return null;
            }
            if (object instanceof XmlTag) {
                return (XmlTag)object;
            }
            XmlNSDescriptor nsDescriptorByContext = JspXmlDocumentationProvider.getNSDescriptorByContext(tag, object);
            if (nsDescriptorByContext != null) {
                return nsDescriptorByContext.getDeclaration();
            }
            XmlElementDescriptor tagDescriptor = tag.getDescriptor();
            if (tagDescriptor != null && object instanceof String && (attributeDescriptor = tagDescriptor.getAttributeDescriptor((String)object, tag)) != null && attributeDescriptor.getDeclaration() != null) {
                return attributeDescriptor.getDeclaration();
            }
        }
        if (object == null) {
            return null;
        }
        return super.getDocumentationElementForLookupItem(psiManager, object, element);
    }

    @Nullable
    private static XmlNSDescriptor getNSDescriptorByContext(XmlTag jspTag, Object object) {
        if (jspTag == null || object == null) {
            return null;
        }
        String namespaceByPrefix = jspTag.getNamespaceByPrefix(object.toString());
        return jspTag.getNSDescriptor(namespaceByPrefix, true);
    }
}

