/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.javaee.web.WebUtil;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.jsp.JspFileIndex;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspUtil;
import com.intellij.psi.jsp.JstlUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JspFileIndexEx
extends JspFileIndex {
    protected final PsiManager myPsiManager;
    private final DumbService myDumbService;

    public JspFileIndexEx(PsiManager psiManager, DumbService dumbService) {
        this.myPsiManager = psiManager;
        this.myDumbService = dumbService;
    }

    protected static List<JspIncludeInfo> findIncludedFilesWithOffsets(@NotNull BaseJspFile jspFile) {
        JspIncludeInfo info;
        if (jspFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jspFile", "com/intellij/psi/impl/source/jsp/JspFileIndexEx", "findIncludedFilesWithOffsets"));
        }
        ArrayList<JspIncludeInfo> pairs = new ArrayList<JspIncludeInfo>();
        for (PathReference prelude : WebUtil.getPreludes((BaseJspFile)jspFile)) {
            pairs.add(JspIncludeInfo.createFromWebPath(prelude, 0));
        }
        for (PathReference prelude : WebUtil.getCodas((BaseJspFile)jspFile)) {
            pairs.add(JspIncludeInfo.createFromWebPath(prelude, jspFile.getTextLength()));
        }
        for (XmlTag tag : jspFile.getDirectiveTags(JspDirectiveKind.INCLUDE, false)) {
            if (!tag.isValid() || (info = JspIncludeInfo.createFromIncludeDirective(tag)) == null) continue;
            pairs.add(info);
        }
        for (XmlTag tag : JstlUtil.getImportTags(jspFile)) {
            if (!tag.isValid() || (info = JspIncludeInfo.createFromImportTag(tag)) == null) continue;
            pairs.add(info);
        }
        return pairs;
    }

    @Override
    public BaseJspFile[] getIncludingFiles(@NotNull PsiFile file, Set<? extends BaseJspFile> visited) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspFileIndexEx", "getIncludingFiles"));
        }
        if (this.myDumbService.isDumb()) {
            return BaseJspFile.EMPTY_ARRAY;
        }
        JspFileCollector collector = new JspFileCollector();
        this.processIncludingFiles(file, collector);
        return collector.getResult();
    }

    @Override
    public BaseJspFile[] getIncludingFiles(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspFileIndexEx", "getIncludingFiles"));
        }
        return this.getIncludingFiles(file, new HashSet());
    }

    @Override
    @Nullable
    public BaseJspFile getFirstIncludingFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspFileIndexEx", "getFirstIncludingFile"));
        }
        if (this.myDumbService.isDumb()) {
            return null;
        }
        final BaseJspFile[] includingFile = new BaseJspFile[]{null};
        this.processIncludingFiles(file, new JspFileIndex.JspFileProcessor(){

            @Override
            public boolean process(@NotNull BaseJspFile file, int offset, boolean isInclude) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspFileIndexEx$1", "process"));
                }
                includingFile[0] = file;
                return false;
            }
        });
        return includingFile[0];
    }

    @Override
    public Pair<BaseJspFile, Integer>[] getIncludingFilesWithIncludeDirectiveOffsets(@NotNull BaseJspFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspFileIndexEx", "getIncludingFilesWithIncludeDirectiveOffsets"));
        }
        final ArrayList pairs = new ArrayList();
        this.processIncludingFiles((PsiFile)file, new JspFileIndex.JspFileProcessor(){

            @Override
            public boolean process(@NotNull BaseJspFile file, int offset, boolean isInclude) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspFileIndexEx$2", "process"));
                }
                pairs.add(Pair.create((Object)file, (Object)offset));
                return true;
            }
        });
        return pairs.toArray(new Pair[pairs.size()]);
    }

    @Override
    public int getFirstIncludeElementForFile(BaseJspFile file, BaseJspFile referencedFile) {
        int minOffset = Integer.MAX_VALUE;
        for (JspIncludeInfo info : JspFileIndexEx.findIncludedFilesWithOffsets(file)) {
            int offset;
            PsiFile includedFile = info.getFile();
            if (includedFile == null || !referencedFile.equals(includedFile) || minOffset <= (offset = info.getOffset())) continue;
            minOffset = offset;
        }
        return minOffset == Integer.MAX_VALUE ? -1 : minOffset;
    }

    @Override
    public BaseJspFile[] getIncludedFiles(@NotNull BaseJspFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspFileIndexEx", "getIncludedFiles"));
        }
        JspFileCollector processor = new JspFileCollector();
        this.processIncludedFiles(file, processor);
        return processor.getResult();
    }

    @Override
    public boolean isIncluded(@NotNull VirtualFile BaseJspFile2) {
        if (BaseJspFile2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "BaseJspFile", "com/intellij/psi/impl/source/jsp/JspFileIndexEx", "isIncluded"));
        }
        PsiFile psiFile = this.myPsiManager.findFile(BaseJspFile2);
        final Ref ref = Ref.create((Object)false);
        JspFileIndex.JspFileProcessor processor = new JspFileIndex.JspFileProcessor(){

            @Override
            public boolean process(@NotNull BaseJspFile file, int includeDirectiveOffset, boolean isInclude) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspFileIndexEx$3", "process"));
                }
                ref.set((Object)true);
                return false;
            }
        };
        this.processIncludingFiles(psiFile, processor);
        return (Boolean)ref.get();
    }

    @Override
    public boolean isIncludingAnything(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/psi/impl/source/jsp/JspFileIndexEx", "isIncludingAnything"));
        }
        PsiFile psiFile = this.myPsiManager.findFile(vFile);
        return psiFile instanceof BaseJspFile && this.processIncludedFiles((BaseJspFile)psiFile, new JspFileIndex.JspFileProcessor(){

            @Override
            public boolean process(@NotNull BaseJspFile file, int includeDirectiveOffset, boolean isInclude) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspFileIndexEx$4", "process"));
                }
                return false;
            }
        });
    }

    @Override
    public void traverseIncludesGraph(BaseJspFile jspFile, final JspFileIndex.JspFileProcessor processor, final boolean includesOnly) {
        final HashSet<BaseJspFile> visited = new HashSet<BaseJspFile>();
        visited.add(jspFile);
        JspFileIndex.JspFileProcessor recursiveProcessor = new JspFileIndex.JspFileProcessor(){

            @Override
            public boolean process(@NotNull BaseJspFile file, int includeDirectiveOffset, boolean isInclude) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspFileIndexEx$5", "process"));
                }
                if (!visited.add(file)) {
                    return true;
                }
                processor.process(file, includeDirectiveOffset, isInclude);
                JspFileIndexEx.this.doTraverse(file, this, includesOnly || isInclude);
                return true;
            }
        };
        this.doTraverse(jspFile, recursiveProcessor, includesOnly);
    }

    private void doTraverse(BaseJspFile jspFile, final JspFileIndex.JspFileProcessor processor, boolean includesOnly) {
        this.processIncludedFiles(jspFile, processor);
        if (!includesOnly) {
            this.processIncludingFiles((PsiFile)jspFile, new JspFileIndex.JspFileProcessor(){
                int counter;

                @Override
                public boolean process(@NotNull BaseJspFile file, int includeDirectiveOffset, boolean isInclude) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspFileIndexEx$6", "process"));
                    }
                    processor.process(file, includeDirectiveOffset, isInclude);
                    return this.counter++ < 5;
                }
            });
        }
    }

    private static class JspFileCollector
    implements JspFileIndex.JspFileProcessor {
        final List<BaseJspFile> files = new ArrayList<BaseJspFile>();

        private JspFileCollector() {
        }

        @Override
        public boolean process(@NotNull BaseJspFile jspFile, int offset, boolean isInclude) {
            if (jspFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jspFile", "com/intellij/psi/impl/source/jsp/JspFileIndexEx$JspFileCollector", "process"));
            }
            this.files.add(jspFile);
            return true;
        }

        BaseJspFile[] getResult() {
            return this.files.toArray(new BaseJspFile[this.files.size()]);
        }
    }

    protected static class JspIncludeInfo {
        @Nullable
        private PsiFile myFile;
        private final int myOffset;
        @Nullable
        private String myFileName;

        private JspIncludeInfo(@Nullable PsiFile file, int offset) {
            this.myFile = file;
            this.myOffset = offset;
        }

        public JspIncludeInfo(@NotNull String filePath, int offset) {
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/psi/impl/source/jsp/JspFileIndexEx$JspIncludeInfo", "<init>"));
            }
            int index = Math.max(filePath.lastIndexOf(92), filePath.lastIndexOf(47));
            this.myFileName = filePath.substring(index + 1);
            this.myOffset = offset;
        }

        @Nullable
        public PsiFile getFile() {
            return this.myFile;
        }

        public int getOffset() {
            return this.myOffset;
        }

        @Nullable
        public String getFileName() {
            return this.myFileName;
        }

        @NotNull
        private static JspIncludeInfo createFromWebPath(PathReference path, int offset) {
            PsiElement file = path.resolve();
            if (file instanceof PsiFile) {
                JspIncludeInfo jspIncludeInfo = new JspIncludeInfo((PsiFile)file, offset);
                if (jspIncludeInfo == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspFileIndexEx$JspIncludeInfo", "createFromWebPath"));
                }
                return jspIncludeInfo;
            }
            JspIncludeInfo jspIncludeInfo = new JspIncludeInfo(path.getTrimmedPath(), offset);
            if (jspIncludeInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspFileIndexEx$JspIncludeInfo", "createFromWebPath"));
            }
            return jspIncludeInfo;
        }

        @Nullable
        private static JspIncludeInfo createFromIncludeDirective(XmlTag tag) {
            PsiFile file = JspUtil.resolveFileInclude(tag);
            int startOffset = tag.getTextRange().getStartOffset();
            if (file != null) {
                return new JspIncludeInfo(file, startOffset);
            }
            String path = JspUtil.getIncludedFilePath(tag);
            return path != null ? new JspIncludeInfo(path, startOffset) : null;
        }

        @Nullable
        private static JspIncludeInfo createFromImportTag(XmlTag tag) {
            PsiFile file = JstlUtil.resolveImportTag(tag);
            int startOffset = tag.getTextRange().getStartOffset();
            if (file != null) {
                return new JspIncludeInfo(file, startOffset);
            }
            String path = JstlUtil.getImportFilePath(tag);
            return path != null ? new JspIncludeInfo(path, startOffset) : null;
        }
    }
}

