/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.jsp;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.lang.java.parser.StatementParser;
import com.intellij.openapi.util.Key;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.jsp.BaseJspElementType;
import com.intellij.psi.jsp.ELElementType;
import com.intellij.psi.jsp.JspElementTypeEx;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.tree.CustomParsingType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.tree.jsp.IJspElementType;
import com.intellij.psi.tree.xml.IXmlElementType;
import com.intellij.psi.xml.XmlTokenType;
import org.jetbrains.annotations.NotNull;

public class JspJavaParser {
    private static final Key<Boolean> TERMINATE_JSP = Key.create((String)"jsp.java.parser.terminate.key");
    private static final TokenSet TEMPLATE_DATA = TokenSet.create((IElementType[])new IElementType[]{BaseJspElementType.JSP_DIRECTIVE, ELElementType.JSP_EL_HOLDER, JspTokenType.JSP_TEMPLATE_DATA, JspTokenType.JSP_COMMENT, XmlTokenType.XML_TAG_NAME, XmlTokenType.XML_NAME, XmlTokenType.XML_END_TAG_START, XmlTokenType.XML_EQ, XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER, XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_TAG_END, XmlTokenType.XML_EMPTY_ELEMENT_END});
    private static final TokenSet TEMPLATE_TOKEN = TokenSet.create((IElementType[])new IElementType[]{JspTokenType.JSPX_ROOT_TAG_HEADER, JspTokenType.JSPX_ROOT_TAG_FOOTER, JspTokenType.JSP_SCRIPTLET_START, JspTokenType.JSP_SCRIPTLET_END});
    private static final JavaParser JAVA_PARSER = new JavaParser(){
        private final StatementParser myStatementParser = new StatementParser(this){

            public PsiBuilder.Marker parseStatement(PsiBuilder builder) {
                if (!JspJavaParser.isTerminated(builder)) {
                    IElementType tt = builder.getTokenType();
                    if (TEMPLATE_DATA.contains(tt)) {
                        return JspJavaParser.parseTemplateDataStatement(builder, false);
                    }
                    if (TEMPLATE_TOKEN.contains(tt)) {
                        return JspJavaParser.parseTemplateDataStatement(builder, true);
                    }
                    if (tt == JspTokenType.JSP_DECLARATION_START) {
                        return JspJavaParser.parseJspClassLevelDeclarationStatement(builder);
                    }
                    if (tt == JspTokenType.JSP_EXPRESSION_START) {
                        return JspJavaParser.parseJspExpressionStatement(builder);
                    }
                    if (tt == XmlTokenType.XML_START_TAG_START) {
                        return JspJavaParser.parseJspAction(builder);
                    }
                }
                return super.parseStatement(builder);
            }
        };

        @NotNull
        public StatementParser getStatementParser() {
            StatementParser statementParser = this.myStatementParser;
            if (statementParser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspJavaParser$1", "getStatementParser"));
            }
            return statementParser;
        }
    };

    private JspJavaParser() {
    }

    public static void parse(PsiBuilder builder) {
        builder.enforceCommentTokens(ElementType.JAVA_COMMENT_BIT_SET);
        JavaParserUtil.setParseStatementCodeBlocksDeep((PsiBuilder)builder, (boolean)true);
        builder.mark().done(JspElementTypeEx.JSP_IMPORT_LIST_WRAPPER);
        JspJavaParser.parseJspClass(builder);
    }

    private static void parseJspClass(PsiBuilder builder) {
        PsiBuilder.Marker jspClass = builder.mark();
        PsiBuilder.Marker jspMethod = builder.mark();
        PsiBuilder.Marker block = builder.mark();
        JspJavaParser.parseJspCodeBlock(builder);
        if (!builder.eof()) {
            builder.mark().error(JavaErrorMessages.message((String)"unexpected.token", (Object[])new Object[0]));
            while (!builder.eof()) {
                builder.advanceLexer();
            }
        }
        block.done(JspElementTypeEx.JSP_CODE_BLOCK);
        jspMethod.done(JspElementTypeEx.HOLDER_METHOD);
        jspClass.done(JspElementTypeEx.JSP_CLASS);
    }

    private static void parseJspCodeBlock(PsiBuilder builder) {
        while (JAVA_PARSER.getStatementParser().parseStatement(builder) != null) {
        }
    }

    @NotNull
    private static PsiBuilder.Marker parseTemplateDataStatement(PsiBuilder builder, boolean single) {
        PsiBuilder.Marker templateStatement = builder.mark();
        if (single) {
            builder.remapCurrentToken(JspElementTypeEx.JSP_TEMPLATE_DATA_WRAPPER);
            builder.advanceLexer();
        } else {
            PsiBuilder.Marker templateData = builder.mark();
            IElementType lastToken = null;
            boolean endTagPassed = false;
            while (TEMPLATE_DATA.contains(builder.getTokenType())) {
                lastToken = builder.getTokenType();
                if (lastToken == XmlTokenType.XML_END_TAG_START) {
                    endTagPassed = true;
                }
                builder.advanceLexer();
                if (lastToken != XmlTokenType.XML_TAG_END && lastToken != XmlTokenType.XML_EMPTY_ELEMENT_END) continue;
            }
            templateData.collapse(JspElementTypeEx.JSP_TEMPLATE_DATA_WRAPPER);
            JspJavaParser.setTerminated(builder, endTagPassed && lastToken == XmlTokenType.XML_TAG_END || lastToken == XmlTokenType.XML_EMPTY_ELEMENT_END);
        }
        templateStatement.done(JspElementTypeEx.JSP_TEMPLATE_STATEMENT);
        PsiBuilder.Marker marker = templateStatement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspJavaParser", "parseTemplateDataStatement"));
        }
        return marker;
    }

    @NotNull
    private static PsiBuilder.Marker parseJspClassLevelDeclarationStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        JspJavaParser.wrap(builder, JspElementTypeEx.JSP_DECLARATION_START_WRAPPER);
        PsiBuilder builderWrapper = JavaParserUtil.stoppingBuilder((PsiBuilder)builder, token -> JspJavaParser.isJspToken((IElementType)token.first));
        JavaParser.INSTANCE.getDeclarationParser().parseClassBodyDeclarations(builderWrapper, false);
        JspJavaParser.extraTokens(builder);
        if (builder.getTokenType() == JspTokenType.JSP_DECLARATION_END) {
            JspJavaParser.wrap(builder, JspElementTypeEx.JSP_DECLARATION_END_WRAPPER);
        }
        statement.done(JspElementTypeEx.JSP_CLASS_LEVEL_DECLARATION_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspJavaParser", "parseJspClassLevelDeclarationStatement"));
        }
        return marker;
    }

    @NotNull
    private static PsiBuilder.Marker parseJspExpressionStatement(PsiBuilder builder) {
        PsiBuilder.Marker statement = builder.mark();
        JspJavaParser.wrap(builder, JspElementTypeEx.JSP_EXPRESSION_START_WRAPPER);
        PsiBuilder.Marker call = builder.mark();
        PsiBuilder.Marker exprList = builder.mark();
        if (JavaParser.INSTANCE.getExpressionParser().parse(builder) == null) {
            JavaParserUtil.error((PsiBuilder)builder, (String)JavaErrorMessages.message((String)"expression.expected", (Object[])new Object[0]));
        }
        JspJavaParser.extraTokens(builder);
        exprList.done(JspElementTypeEx.JSP_EXPRESSION_LIST);
        call.done(JspElementTypeEx.JSP_METHOD_CALL);
        if (builder.getTokenType() == JspTokenType.JSP_EXPRESSION_END) {
            JspJavaParser.wrap(builder, JspElementTypeEx.JSP_EXPRESSION_END_WRAPPER);
        }
        statement.done(JspElementTypeEx.JSP_EXPRESSION_STATEMENT);
        PsiBuilder.Marker marker = statement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspJavaParser", "parseJspExpressionStatement"));
        }
        return marker;
    }

    @NotNull
    private static PsiBuilder.Marker parseJspAction(PsiBuilder builder) {
        PsiBuilder.Marker whileStatement = builder.mark();
        PsiBuilder.Marker blockStatement = builder.mark();
        PsiBuilder.Marker block = builder.mark();
        if (JspJavaParser.skipTagDetails(builder)) {
            JspJavaParser.parseJspCodeBlock(builder);
            JspJavaParser.setTerminated(builder, false);
        }
        block.done(JspElementTypeEx.JSP_CODE_BLOCK);
        blockStatement.done(JspElementTypeEx.JSP_BLOCK_STATEMENT);
        whileStatement.done(JspElementTypeEx.JSP_WHILE_STATEMENT);
        PsiBuilder.Marker marker = whileStatement;
        if (marker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/jsp/JspJavaParser", "parseJspAction"));
        }
        return marker;
    }

    private static boolean skipTagDetails(PsiBuilder builder) {
        IElementType tt;
        PsiBuilder.Marker marker = builder.mark();
        boolean advanced = false;
        while (true) {
            if ((tt = builder.getTokenType()) == JspTokenType.JSP_EXPRESSION_START) {
                if (advanced) {
                    marker.collapse(JspElementTypeEx.JSP_TEMPLATE_DATA_WRAPPER);
                    marker.precede().done(JspElementTypeEx.JSP_TEMPLATE_STATEMENT);
                } else {
                    marker.drop();
                }
                JspJavaParser.parseJspExpressionStatement(builder);
                marker = builder.mark();
                advanced = false;
                continue;
            }
            builder.advanceLexer();
            advanced = true;
            if (tt == XmlTokenType.XML_TAG_END || tt == XmlTokenType.XML_EMPTY_ELEMENT_END || tt == null) break;
        }
        marker.collapse(JspElementTypeEx.JSP_TEMPLATE_DATA_WRAPPER);
        marker.precede().done(JspElementTypeEx.JSP_TEMPLATE_STATEMENT);
        return tt == XmlTokenType.XML_TAG_END;
    }

    private static void wrap(PsiBuilder builder, IElementType token) {
        PsiBuilder.Marker expr = builder.mark();
        builder.remapCurrentToken(token);
        builder.advanceLexer();
        expr.done(JspElementTypeEx.JSP_TEMPLATE_EXPRESSION);
    }

    private static void extraTokens(PsiBuilder builder) {
        IElementType tt;
        PsiBuilder.Marker error = null;
        while ((tt = builder.getTokenType()) != null && !JspJavaParser.isJspToken(tt)) {
            if (error == null) {
                error = builder.mark();
            }
            builder.advanceLexer();
        }
        if (error != null) {
            error.error(JavaErrorMessages.message((String)"unexpected.token", (Object[])new Object[0]));
        }
    }

    private static boolean isJspToken(IElementType token) {
        return token instanceof IJspElementType || token instanceof IXmlElementType || (token instanceof CustomParsingType || token instanceof ILazyParseableElementType) && token.getLanguage() == StdLanguages.JSP;
    }

    private static boolean isTerminated(PsiBuilder builder) {
        return Boolean.TRUE.equals(builder.getUserDataUnprotected(TERMINATE_JSP));
    }

    private static void setTerminated(PsiBuilder builder, boolean value) {
        builder.putUserDataUnprotected(TERMINATE_JSP, (Object)value);
    }
}

